/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import org.mockftpserver.core.util.Assert;

public class Permissions {
    public static final Permissions ALL = new Permissions("rwxrwxrwx");
    public static final Permissions NONE = new Permissions("---------");
    public static final Permissions DEFAULT = ALL;
    private static final char READ_CHAR = 'r';
    private static final char WRITE_CHAR = 'w';
    private static final char EXECUTE_CHAR = 'x';
    private String rwxString;

    public Permissions(String rwxString) {
        Assert.isTrue(rwxString.length() == 9, "The permissions string must be exactly 9 characters");
        String RWX = "(-|r)(-|w)(-|x)";
        String PATTERN = "(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)";
        Assert.isTrue(rwxString.matches("(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)"), "The permissions string must match [(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)(-|r)(-|w)(-|x)]");
        this.rwxString = rwxString;
    }

    public String asRwxString() {
        return this.rwxString;
    }

    public String getRwxString() {
        return this.rwxString;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && object.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.rwxString.hashCode();
    }

    public boolean canUserRead() {
        return this.rwxString.charAt(0) == 'r';
    }

    public boolean canUserWrite() {
        return this.rwxString.charAt(1) == 'w';
    }

    public boolean canUserExecute() {
        return this.rwxString.charAt(2) == 'x';
    }

    public boolean canGroupRead() {
        return this.rwxString.charAt(3) == 'r';
    }

    public boolean canGroupWrite() {
        return this.rwxString.charAt(4) == 'w';
    }

    public boolean canGroupExecute() {
        return this.rwxString.charAt(5) == 'x';
    }

    public boolean canWorldRead() {
        return this.rwxString.charAt(6) == 'r';
    }

    public boolean canWorldWrite() {
        return this.rwxString.charAt(7) == 'w';
    }

    public boolean canWorldExecute() {
        return this.rwxString.charAt(8) == 'x';
    }

    public String toString() {
        return "Permissions[" + this.rwxString + "]";
    }
}

