/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.stub.command.AbstractStubDataCommandHandler;

public class RetrCommandHandler
extends AbstractStubDataCommandHandler
implements CommandHandler {
    public static final String PATHNAME_KEY = "pathname";
    private byte[] fileContents = new byte[0];

    public RetrCommandHandler() {
    }

    public RetrCommandHandler(String fileContents) {
        this.setFileContents(fileContents);
    }

    public RetrCommandHandler(byte[] fileContents) {
        this.setFileContents(fileContents);
    }

    protected void beforeProcessData(Command command, Session session, InvocationRecord invocationRecord) throws Exception {
        String filename = command.getRequiredParameter(0);
        invocationRecord.set(PATHNAME_KEY, filename);
    }

    protected void processData(Command command, Session session, InvocationRecord invocationRecord) {
        this.LOG.info("Sending " + this.fileContents.length + " bytes");
        session.sendData(this.fileContents, this.fileContents.length);
    }

    public void setFileContents(String fileContents) {
        Assert.notNull(fileContents, "fileContents");
        this.setFileContents(fileContents.getBytes());
    }

    public void setFileContents(byte[] fileContents) {
        Assert.notNull(fileContents, "fileContents");
        this.fileContents = fileContents;
    }
}

