/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.util;

import java.util.Collection;
import java.util.Map;
import org.mockftpserver.core.util.AssertFailedException;

public final class Assert {
    public static void isNull(Object arg, String argName) {
        if (arg != null) {
            throw new AssertFailedException("The value for \"" + argName + "\" must be null");
        }
    }

    public static void notNull(Object arg, String argName) {
        if (arg == null) {
            throw new AssertFailedException("The value of \"" + argName + "\" is null");
        }
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            throw new AssertFailedException(message);
        }
    }

    public static void isFalse(boolean condition, String message) {
        if (condition) {
            throw new AssertFailedException(message);
        }
    }

    public static void notNullOrEmpty(Collection collection, String argName) {
        Assert.notNull(collection, argName);
        if (collection.isEmpty()) {
            throw new AssertFailedException("The \"" + argName + "\" Collection is empty");
        }
    }

    public static void notNullOrEmpty(Map map, String argName) {
        Assert.notNull(map, argName);
        if (map.isEmpty()) {
            throw new AssertFailedException("The \"" + argName + "\" Map is empty");
        }
    }

    public static void notNullOrEmpty(Object[] array, String argName) {
        Assert.notNull(array, argName);
        if (array.length == 0) {
            throw new AssertFailedException("The \"" + argName + "\" array is empty");
        }
    }

    public static void notNullOrEmpty(String string, String argName) {
        Assert.notNull(string, argName);
        if (string.trim().length() == 0) {
            throw new AssertFailedException("The \"" + argName + "\" String is empty");
        }
    }

    private Assert() {
    }
}

