/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;

public class RmdCommandHandler
extends AbstractFakeCommandHandler {
    @Override
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        String path = this.getRealPath(session, command.getRequiredParameter(0));
        this.replyCodeForFileSystemException = 550;
        this.verifyFileSystemCondition(this.getFileSystem().exists(path), path, "filesystem.doesNotExist");
        this.verifyFileSystemCondition(this.getFileSystem().isDirectory(path), path, "filesystem.isNotADirectory");
        this.verifyFileSystemCondition(this.getFileSystem().listNames(path).size() == 0, path, "filesystem.directoryIsNotEmpty");
        this.verifyWritePermission(session, this.getFileSystem().getParent(path));
        this.getFileSystem().delete(path);
        this.sendReply(session, 250, "rmd", this.list(path));
    }
}

