/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.kotlin;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.kotlin.MockitoKotlinException;
import org.mockito.kotlin.MockitoKt;
import org.mockito.kotlin.internal.CreateInstanceKt;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0001\u0010\u000b*\u00020\u00022\u0019\u0010\f\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\u000f\u00a2\u0006\u0002\b\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0012J;\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\n\b\u0001\u0010\u000b\u0018\u0001*\u00020\u00022\u001b\b\b\u0010\f\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\u000f\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000J+\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0001\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\b\u0010JT\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0001\u0010\u0001*\u00020\u0002\"\u0004\b\u0002\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u00010\u00002'\u0010\u0014\u001a#\b\u0001\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0015\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0017J#\u0010\t\u001a\u00020\u0018*\u00020\u00192\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u000f\u00a2\u0006\u0002\b\u0010R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Lorg/mockito/kotlin/KStubbing;", "T", "", "mock", "<init>", "(Ljava/lang/Object;)V", "getMock", "()Ljava/lang/Object;", "Ljava/lang/Object;", "on", "Lorg/mockito/stubbing/OngoingStubbing;", "R", "methodCall", "(Ljava/lang/Object;)Lorg/mockito/stubbing/OngoingStubbing;", "onGeneric", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "c", "Lkotlin/reflect/KClass;", "onBlocking", "m", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Lorg/mockito/kotlin/KStubbing;Lkotlin/jvm/functions/Function2;)Lorg/mockito/stubbing/OngoingStubbing;", "", "Lorg/mockito/stubbing/Stubber;", "mockito-kotlin"})
public final class KStubbing<T> {
    @NotNull
    private final T mock;

    public KStubbing(@NotNull T mock) {
        Intrinsics.checkNotNullParameter(mock, (String)"mock");
        this.mock = mock;
        if (!MockitoKt.mockingDetails(this.mock).isMock()) {
            throw new NotAMockException("Stubbing target is not a mock!");
        }
    }

    @NotNull
    public final T getMock() {
        return this.mock;
    }

    @NotNull
    public final <R> OngoingStubbing<R> on(R methodCall) {
        OngoingStubbing ongoingStubbing = Mockito.when(methodCall);
        Intrinsics.checkNotNullExpressionValue((Object)ongoingStubbing, (String)"when(...)");
        return ongoingStubbing;
    }

    @NotNull
    public final <R> OngoingStubbing<R> onGeneric(@NotNull Function1<? super T, ? extends R> methodCall, @NotNull KClass<R> c) {
        Object object;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        try {
            object = methodCall.invoke(this.mock);
        }
        catch (NullPointerException e) {
            object = CreateInstanceKt.createInstance(c);
        }
        Object r = object;
        OngoingStubbing ongoingStubbing = Mockito.when(r);
        Intrinsics.checkNotNullExpressionValue((Object)ongoingStubbing, (String)"when(...)");
        return ongoingStubbing;
    }

    public final /* synthetic */ <R> OngoingStubbing<R> onGeneric(Function1<? super T, ? extends R> methodCall) {
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        boolean $i$f$onGeneric = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"R");
        return this.onGeneric(methodCall, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public final <R> OngoingStubbing<R> on(@NotNull Function1<? super T, ? extends R> methodCall) {
        OngoingStubbing ongoingStubbing;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        try {
            ongoingStubbing = Mockito.when((Object)methodCall.invoke(this.mock));
            Intrinsics.checkNotNull((Object)ongoingStubbing);
        }
        catch (NullPointerException e) {
            throw new MockitoKotlinException("NullPointerException thrown when stubbing.\nThis may be due to two reasons:\n\t- The method you're trying to stub threw an NPE: look at the stack trace below;\n\t- You're trying to stub a generic method: try `onGeneric` instead.", e);
        }
        return ongoingStubbing;
    }

    @NotNull
    public final <T, R> OngoingStubbing<R> onBlocking(@NotNull KStubbing<? extends T> $this$onBlocking, @NotNull Function2<? super T, ? super Continuation<? super R>, ? extends Object> m) {
        Intrinsics.checkNotNullParameter($this$onBlocking, (String)"<this>");
        Intrinsics.checkNotNullParameter(m, (String)"m");
        Object object = BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super OngoingStubbing<R>>, Object>(m, $this$onBlocking, null){
            int label;
            final /* synthetic */ Function2<T, Continuation<? super R>, Object> $m;
            final /* synthetic */ KStubbing<T> $this_onBlocking;
            {
                this.$m = $m;
                this.$this_onBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$m.invoke(this.$this_onBlocking.getMock(), (Object)((Object)this));
                        if (object3 != object2) return Mockito.when((Object)object3);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Mockito.when((Object)object3);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super OngoingStubbing<R>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null);
        Intrinsics.checkNotNull((Object)object);
        return (OngoingStubbing)object;
    }

    public final void on(@NotNull Stubber $this$on, @NotNull Function1<? super T, Unit> methodCall) {
        Intrinsics.checkNotNullParameter((Object)$this$on, (String)"<this>");
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        Object object = $this$on.when(this.mock);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when(...)");
        methodCall.invoke(object);
    }
}

