/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlin;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KAnnotatedElements;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.kotlin.ArrayCodec;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.bson.codecs.pojo.annotations.BsonExtraElements;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.codecs.pojo.annotations.BsonRepresentation;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002-.B/\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c2\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c2\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c2\u0003J?\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u001d\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010!J7\u0010\"\u001a\u00020\u001b\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u001e\u001a\u0002H\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u000eH\u00d6\u0001R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/bson/codecs/kotlin/DataClassCodec;", "T", "", "Lorg/bson/codecs/Codec;", "kClass", "Lkotlin/reflect/KClass;", "primaryConstructor", "Lkotlin/reflect/KFunction;", "propertyModels", "", "Lorg/bson/codecs/kotlin/DataClassCodec$PropertyModel;", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KFunction;Ljava/util/List;)V", "fieldNamePropertyModelMap", "", "", "propertyModelId", "component1", "component2", "component3", "copy", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "encode", "", "writer", "Lorg/bson/BsonWriter;", "value", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "encodeProperty", "propertyModel", "(Lorg/bson/codecs/kotlin/DataClassCodec$PropertyModel;Ljava/lang/Object;Lorg/bson/BsonWriter;Lorg/bson/codecs/EncoderContext;)V", "equals", "", "other", "getEncoderClass", "Ljava/lang/Class;", "hashCode", "", "toString", "Companion", "PropertyModel", "bson-kotlin"})
@SourceDebugExtension(value={"SMAP\nDataClassCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassCodec.kt\norg/bson/codecs/kotlin/DataClassCodec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1194#2,2:265\n1222#2,4:267\n766#2:271\n857#2,2:272\n1855#2,2:274\n1855#2,2:276\n288#2,2:278\n*S KotlinDebug\n*F\n+ 1 DataClassCodec.kt\norg/bson/codecs/kotlin/DataClassCodec\n*L\n58#1:265,2\n58#1:267,4\n69#1:271\n69#1:272,2\n70#1:274,2\n79#1:276,2\n120#1:278,2\n*E\n"})
public final class DataClassCodec<T>
implements Codec<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<T> kClass;
    @NotNull
    private final KFunction<T> primaryConstructor;
    @NotNull
    private final List<PropertyModel> propertyModels;
    @NotNull
    private final Map<String, PropertyModel> fieldNamePropertyModelMap;
    @Nullable
    private final PropertyModel propertyModelId;
    private static final Logger logger = Loggers.getLogger((String)"DataClassCodec");
    @NotNull
    private static final String idFieldName = "_id";

    /*
     * WARNING - void declaration
     */
    public DataClassCodec(@NotNull KClass<T> kClass, @NotNull KFunction<? extends T> primaryConstructor, @NotNull List<PropertyModel> propertyModels) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(primaryConstructor, (String)"primaryConstructor");
        Intrinsics.checkNotNullParameter(propertyModels, (String)"propertyModels");
        this.kClass = kClass;
        this.primaryConstructor = primaryConstructor;
        this.propertyModels = propertyModels;
        Iterable iterable = this.propertyModels;
        DataClassCodec dataClassCodec = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PropertyModel propertyModel = (PropertyModel)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getFieldName(), element$iv$iv);
        }
        dataClassCodec.fieldNamePropertyModelMap = destination$iv$iv;
        this.propertyModelId = this.fieldNamePropertyModelMap.get(idFieldName);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(@NotNull BsonWriter writer, @NotNull T value, @NotNull EncoderContext encoderContext) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)encoderContext, (String)"encoderContext");
        writer.writeStartDocument();
        if (this.propertyModelId != null) {
            this.encodeProperty(this.propertyModelId, value, writer, encoderContext);
        }
        Iterable iterable = this.propertyModels;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PropertyModel it = (PropertyModel)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)this.propertyModelId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyModel propertyModel = (PropertyModel)element$iv;
            boolean bl = false;
            this.encodeProperty(propertyModel, value, writer, encoderContext);
        }
        writer.writeEndDocument();
    }

    @NotNull
    public Class<T> getEncoderClass() {
        return JvmClassMappingKt.getJavaClass(this.kClass);
    }

    @NotNull
    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        Map args = new LinkedHashMap();
        Iterable $this$forEach$iv = this.fieldNamePropertyModelMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyModel it = (PropertyModel)element$iv;
            boolean bl = false;
            args.put(it.getParam(), null);
        }
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            PropertyModel propertyModel = this.fieldNamePropertyModelMap.get(fieldName);
            if (propertyModel == null) {
                reader.skipValue();
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Found property not present in the DataClass: " + fieldName);
                continue;
            }
            if (propertyModel.getParam().getType().isMarkedNullable() && reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                continue;
            }
            try {
                args.put(propertyModel.getParam(), decoderContext.decodeWithChildContext((Decoder)propertyModel.getCodec(), reader));
            }
            catch (Exception e) {
                throw new CodecConfigurationException("Unable to decode " + fieldName + " for " + this.kClass.getSimpleName() + " data class.", (Throwable)e);
            }
        }
        reader.readEndDocument();
        try {
            return (T)this.primaryConstructor.callBy(args);
        }
        catch (Exception e) {
            throw new CodecConfigurationException("Unable to invoke primary constructor of " + this.kClass.getSimpleName() + " data class", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void encodeProperty(PropertyModel propertyModel, T value, BsonWriter writer, EncoderContext encoderContext) {
        block3: {
            Object propertyValue;
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                Iterable iterable = Reflection.getOrCreateKotlinClass(value.getClass()).getMembers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KCallable it = (KCallable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)propertyModel.getParam().getName())) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            KCallable kCallable = v0;
            if (kCallable == null) break block3;
            KCallable it = kCallable;
            boolean bl = false;
            Object object = propertyValue = ((KProperty1)it).get(value);
            if (object != null) {
                Object pValue = object;
                boolean bl2 = false;
                writer.writeName(propertyModel.getFieldName());
                encoderContext.encodeWithChildContext((Encoder)propertyModel.getCodec(), writer, pValue);
            }
        }
    }

    private final KClass<T> component1() {
        return this.kClass;
    }

    private final KFunction<T> component2() {
        return this.primaryConstructor;
    }

    private final List<PropertyModel> component3() {
        return this.propertyModels;
    }

    @NotNull
    public final DataClassCodec<T> copy(@NotNull KClass<T> kClass, @NotNull KFunction<? extends T> primaryConstructor, @NotNull List<PropertyModel> propertyModels) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(primaryConstructor, (String)"primaryConstructor");
        Intrinsics.checkNotNullParameter(propertyModels, (String)"propertyModels");
        return new DataClassCodec<T>(kClass, primaryConstructor, propertyModels);
    }

    public static /* synthetic */ DataClassCodec copy$default(DataClassCodec dataClassCodec, KClass kClass, KFunction kFunction, List list, int n, Object object) {
        if ((n & 1) != 0) {
            kClass = dataClassCodec.kClass;
        }
        if ((n & 2) != 0) {
            kFunction = dataClassCodec.primaryConstructor;
        }
        if ((n & 4) != 0) {
            list = dataClassCodec.propertyModels;
        }
        return dataClassCodec.copy(kClass, kFunction, list);
    }

    @NotNull
    public String toString() {
        return "DataClassCodec(kClass=" + this.kClass + ", primaryConstructor=" + this.primaryConstructor + ", propertyModels=" + this.propertyModels + ')';
    }

    public int hashCode() {
        int result = this.kClass.hashCode();
        result = result * 31 + this.primaryConstructor.hashCode();
        result = result * 31 + ((Object)this.propertyModels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataClassCodec)) {
            return false;
        }
        DataClassCodec dataClassCodec = (DataClassCodec)other;
        if (!Intrinsics.areEqual(this.kClass, dataClassCodec.kClass)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.primaryConstructor, dataClassCodec.primaryConstructor)) {
            return false;
        }
        return Intrinsics.areEqual(this.propertyModels, dataClassCodec.propertyModels);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JE\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010\u0018\"\b\b\u0001\u0010\u0019*\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0000\u00a2\u0006\u0002\b J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\"\u001a\u00020\u00122\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010&\u001a\u00020\u000b\"\b\b\u0001\u0010\u0019*\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002J6\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018*\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010(2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lorg/bson/codecs/kotlin/DataClassCodec$Companion;", "", "()V", "idFieldName", "", "logger", "Lorg/bson/diagnostics/Logger;", "kotlin.jvm.PlatformType", "getLogger$bson_kotlin", "()Lorg/bson/diagnostics/Logger;", "codecConfigurationRequires", "", "value", "", "lazyMessage", "Lkotlin/Function0;", "computeFieldName", "parameter", "Lkotlin/reflect/KParameter;", "computeJavaType", "Ljava/lang/reflect/Type;", "kTypeProjection", "Lkotlin/reflect/KTypeProjection;", "create", "Lorg/bson/codecs/Codec;", "R", "kClass", "Lkotlin/reflect/KClass;", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "types", "", "create$bson_kotlin", "getCodec", "kParameter", "typeMap", "", "Lkotlin/reflect/KClassifier;", "validateAnnotations", "clazz", "Ljava/lang/Class;", "bson-kotlin"})
    @SourceDebugExtension(value={"SMAP\nDataClassCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassCodec.kt\norg/bson/codecs/kotlin/DataClassCodec$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1559#2:265\n1590#2,4:266\n1549#2:270\n1620#2,3:271\n288#2,2:275\n1726#2,2:277\n1728#2:280\n1549#2:281\n1620#2,2:282\n1622#2:286\n288#2,2:289\n288#2,2:292\n1603#2,9:294\n1855#2:303\n1856#2:305\n1612#2:306\n288#2,2:308\n20#3:274\n43#3:279\n43#3:284\n43#3:285\n29#3:287\n20#3:288\n20#3:291\n20#3:307\n1#4:304\n*S KotlinDebug\n*F\n+ 1 DataClassCodec.kt\norg/bson/codecs/kotlin/DataClassCodec$Companion\n*L\n146#1:265\n146#1:266,4\n150#1:270\n150#1:271,3\n161#1:275,2\n167#1:277,2\n167#1:280\n173#1:281\n173#1:282,2\n173#1:286\n188#1:289,2\n191#1:292,2\n207#1:294,9\n207#1:303\n207#1:305\n207#1:306\n246#1:308,2\n161#1:274\n167#1:279\n174#1:284\n179#1:285\n188#1:287\n188#1:288\n191#1:291\n246#1:307\n207#1:304\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$bson_kotlin() {
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final <R> Codec<R> create$bson_kotlin(@NotNull KClass<R> kClass, @NotNull CodecRegistry codecRegistry, @NotNull List<? extends Type> types) {
            Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
            Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
            Intrinsics.checkNotNullParameter(types, (String)"types");
            if (kClass.isData()) {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                this.validateAnnotations(kClass);
                KFunction kFunction = KClasses.getPrimaryConstructor(kClass);
                if (kFunction == null) {
                    throw new CodecConfigurationException("No primary constructor for " + kClass);
                }
                KFunction primaryConstructor = kFunction;
                Iterable iterable = types;
                boolean $i$f$mapIndexed = false;
                void var8_8 = $this$mapIndexed$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void k;
                    void i;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Type type = (Type)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    KClassifier kClassifier = KClassifiers.createType$default((KClassifier)((KClassifier)primaryConstructor.getTypeParameters().get((int)i)), null, (boolean)false, null, (int)7, null).getClassifier();
                    Intrinsics.checkNotNull((Object)kClassifier);
                    collection.add(TuplesKt.to((Object)kClassifier, (Object)k));
                }
                Map typeMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                Iterable $this$map$iv = primaryConstructor.getParameters();
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void kParameter;
                    KParameter kParameter2 = (KParameter)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(new PropertyModel((KParameter)kParameter, Companion.computeFieldName((KParameter)kParameter), Companion.getCodec((KParameter)kParameter, typeMap, codecRegistry)));
                }
                List propertyModels = (List)destination$iv$iv2;
                return new DataClassCodec<R>(kClass, primaryConstructor, propertyModels);
            }
            return null;
        }

        public static /* synthetic */ Codec create$bson_kotlin$default(Companion companion, KClass kClass, CodecRegistry codecRegistry, List list, int n, Object object) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.create$bson_kotlin(kClass, codecRegistry, list);
        }

        /*
         * WARNING - void declaration
         */
        private final <R> void validateAnnotations(KClass<R> kClass) {
            block7: {
                void $this$mapTo$iv$iv;
                Object it;
                boolean bl;
                Object object;
                block6: {
                    void $this$all$iv;
                    Object v0;
                    Iterable $this$findAnnotation$iv;
                    block5: {
                        KAnnotatedElement kAnnotatedElement = (KAnnotatedElement)kClass;
                        object = this;
                        boolean $i$f$findAnnotation = false;
                        Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                        boolean $i$f$firstOrNull = false;
                        Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            Annotation it$iv = (Annotation)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it$iv instanceof BsonDiscriminator)) continue;
                            v0 = element$iv$iv;
                            break block5;
                        }
                        v0 = null;
                    }
                    ((Companion)object).codecConfigurationRequires((Annotation)((BsonDiscriminator)v0) == null, (Function0<String>)((Function0)new Function0<String>(kClass){
                        final /* synthetic */ KClass<R> $kClass;
                        {
                            this.$kClass = $kClass;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("Annotation 'BsonDiscriminator' is not supported on kotlin data classes,\n                    | but found on " + this.$kClass.getSimpleName() + '.'), null, (int)1, null);
                        }
                    }));
                    $this$findAnnotation$iv = kClass.getConstructors();
                    object = this;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (KFunction)element$iv;
                            boolean bl3 = false;
                            KAnnotatedElement $this$findAnnotations$iv = (KAnnotatedElement)it;
                            boolean $i$f$findAnnotations = false;
                            if (KAnnotatedElements.findAnnotations((KAnnotatedElement)$this$findAnnotations$iv, (KClass)Reflection.getOrCreateKotlinClass(BsonCreator.class)).isEmpty()) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                boolean bl4 = bl;
                ((Companion)object).codecConfigurationRequires(bl4, (Function0<String>)((Function0)new Function0<String>(kClass){
                    final /* synthetic */ KClass<R> $kClass;
                    {
                        this.$kClass = $kClass;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return StringsKt.trimMargin$default((String)("Annotation 'BsonCreator' is not supported on kotlin data classes,\n                    | but found in " + this.$kClass.getSimpleName() + '.'), null, (int)1, null);
                    }
                }));
                Object object2 = KClasses.getPrimaryConstructor(kClass);
                if (object2 == null || (object2 = object2.getParameters()) == null) break block7;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    KParameter kParameter = (KParameter)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    KAnnotatedElement $this$findAnnotations$iv = (KAnnotatedElement)param;
                    boolean $i$f$findAnnotations = false;
                    Companion.codecConfigurationRequires(KAnnotatedElements.findAnnotations((KAnnotatedElement)$this$findAnnotations$iv, (KClass)Reflection.getOrCreateKotlinClass(BsonIgnore.class)).isEmpty(), (Function0<String>)((Function0)new Function0<String>((KParameter)param){
                        final /* synthetic */ KParameter $param;
                        {
                            this.$param = $param;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("Annotation 'BsonIgnore' is not supported in kotlin data classes,\n                        | found on the parameter for " + this.$param.getName() + '.'), null, (int)1, null);
                        }
                    }));
                    $this$findAnnotations$iv = (KAnnotatedElement)param;
                    $i$f$findAnnotations = false;
                    Companion.codecConfigurationRequires(KAnnotatedElements.findAnnotations((KAnnotatedElement)$this$findAnnotations$iv, (KClass)Reflection.getOrCreateKotlinClass(BsonExtraElements.class)).isEmpty(), (Function0<String>)((Function0)new Function0<String>((KParameter)param){
                        final /* synthetic */ KParameter $param;
                        {
                            this.$param = $param;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("Annotation 'BsonExtraElements' is not supported in kotlin data classes,\n                        | found on the parameter for " + this.$param.getName() + '.'), null, (int)1, null);
                        }
                    }));
                    object.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }

        private final String computeFieldName(KParameter parameter) {
            String string;
            Object v0;
            block5: {
                KAnnotatedElement $this$hasAnnotation$iv = (KAnnotatedElement)parameter;
                boolean $i$f$hasAnnotation = false;
                KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                    Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                    boolean bl = false;
                    if (!(it$iv$iv instanceof BsonId)) continue;
                    v0 = element$iv$iv$iv;
                    break block5;
                }
                v0 = null;
            }
            boolean bl = (Annotation)((BsonId)v0) != null;
            if (bl) {
                string = DataClassCodec.idFieldName;
            } else {
                Object v3;
                block6: {
                    KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)parameter;
                    boolean $i$f$findAnnotation = false;
                    Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        Annotation it$iv = (Annotation)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it$iv instanceof BsonProperty)) continue;
                        v3 = element$iv$iv;
                        break block6;
                    }
                    v3 = null;
                }
                if (((string = (BsonProperty)((Annotation)((BsonProperty)v3))) == null || (string = string.value()) == null) && (string = parameter.getName()) == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final Codec<Object> getCodec(KParameter kParameter, Map<KClassifier, ? extends Type> typeMap, CodecRegistry codecRegistry) {
            Codec<Object> codec;
            KClassifier kClassifier = kParameter.getType().getClassifier();
            if (kClassifier instanceof KClass) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                KClassifier kClassifier2 = kParameter.getType().getClassifier();
                Intrinsics.checkNotNull((Object)kClassifier2, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
                Iterable iterable = kParameter.getType().getArguments();
                Class clazz = JvmClassMappingKt.getJavaObjectType((KClass)((KClass)kClassifier2));
                KParameter kParameter2 = kParameter;
                CodecRegistry codecRegistry2 = codecRegistry;
                Companion companion = this;
                boolean $i$f$mapNotNull = false;
                void var7_12 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    KTypeProjection it = (KTypeProjection)element$iv$iv;
                    boolean bl2 = false;
                    Map<KClassifier, ? extends Type> map = typeMap;
                    KType kType = it.getType();
                    Type type = map.get(kType != null ? kType.getClassifier() : null);
                    if (type == null) {
                        type = Companion.computeJavaType(it);
                    }
                    if (type == null) continue;
                    Type it$iv$iv = type;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                codec = companion.getCodec(codecRegistry2, kParameter2, clazz, CollectionsKt.toList((Iterable)list));
            } else if (kClassifier instanceof KTypeParameter) {
                Type pType;
                Type type = typeMap.get(kParameter.getType().getClassifier());
                if (type == null) {
                    type = ReflectJvmMapping.getJavaType((KType)kParameter.getType());
                }
                if ((pType = type) instanceof Class) {
                    codec = this.getCodec(codecRegistry, kParameter, JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getKotlinClass((Class)((Class)pType))), CollectionsKt.emptyList());
                } else if (pType instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)pType).getRawType();
                    Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
                    Class clazz = JvmClassMappingKt.getJavaObjectType((KClass)JvmClassMappingKt.getKotlinClass((Class)((Class)type2)));
                    Type[] typeArray = ((ParameterizedType)pType).getActualTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"pType.actualTypeArguments");
                    codec = this.getCodec(codecRegistry, kParameter, clazz, ArraysKt.toList((Object[])typeArray));
                } else {
                    codec = null;
                }
            } else {
                codec = null;
            }
            if (codec == null) {
                throw new CodecConfigurationException("Could not find codec for " + kParameter.getName() + " with type " + kParameter.getType());
            }
            return codec;
        }

        private final Type computeJavaType(KTypeProjection kTypeProjection) {
            KType kType;
            KType kType2 = kTypeProjection.getType();
            Type type = kType2 != null ? ReflectJvmMapping.getJavaType((KType)kType2) : null;
            Intrinsics.checkNotNull((Object)type);
            Type javaType = type;
            return Intrinsics.areEqual((Object)javaType, Object.class) ? (Type)((kType = kTypeProjection.getType()) != null && (kType = KTypesJvm.getJvmErasure((KType)kType)) != null ? JvmClassMappingKt.getJavaObjectType((KClass)kType) : null) : javaType;
        }

        private final Codec<Object> getCodec(CodecRegistry $this$getCodec, KParameter kParameter, Class<Object> clazz, List<? extends Type> types) {
            BsonRepresentation bsonRepresentation;
            block7: {
                Codec codec;
                block6: {
                    Object v0;
                    block5: {
                        codec = clazz.isArray() ? ArrayCodec.Companion.create$bson_kotlin(JvmClassMappingKt.getKotlinClass(clazz), types, $this$getCodec) : (types.isEmpty() ? $this$getCodec.get(clazz) : $this$getCodec.get(clazz, types));
                        KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)kParameter;
                        boolean $i$f$findAnnotation = false;
                        Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                            Annotation it$iv = (Annotation)element$iv$iv;
                            boolean bl = false;
                            if (!(it$iv instanceof BsonRepresentation)) continue;
                            v0 = element$iv$iv;
                            break block5;
                        }
                        v0 = null;
                    }
                    if ((bsonRepresentation = (BsonRepresentation)((Annotation)((BsonRepresentation)v0))) == null) break block6;
                    BsonRepresentation it = bsonRepresentation;
                    boolean bl = false;
                    if (!(codec instanceof RepresentationConfigurable)) {
                        throw new CodecConfigurationException("Codec for `" + kParameter.getName() + "` must implement RepresentationConfigurable to supportBsonRepresentation");
                    }
                    Codec codec2 = ((RepresentationConfigurable)codec).withRepresentation(it.value());
                    Intrinsics.checkNotNull((Object)codec2, (String)"null cannot be cast to non-null type org.bson.codecs.Codec<kotlin.Any>");
                    bsonRepresentation = codec2;
                    if (codec2 != null) break block7;
                }
                Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec");
                bsonRepresentation = codec;
            }
            return bsonRepresentation;
        }

        private final void codecConfigurationRequires(boolean value, Function0<String> lazyMessage) {
            if (!value) {
                throw new CodecConfigurationException((String)lazyMessage.invoke());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/bson/codecs/kotlin/DataClassCodec$PropertyModel;", "", "param", "Lkotlin/reflect/KParameter;", "fieldName", "", "codec", "Lorg/bson/codecs/Codec;", "(Lkotlin/reflect/KParameter;Ljava/lang/String;Lorg/bson/codecs/Codec;)V", "getCodec", "()Lorg/bson/codecs/Codec;", "getFieldName", "()Ljava/lang/String;", "getParam", "()Lkotlin/reflect/KParameter;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "bson-kotlin"})
    public static final class PropertyModel {
        @NotNull
        private final KParameter param;
        @NotNull
        private final String fieldName;
        @NotNull
        private final Codec<Object> codec;

        public PropertyModel(@NotNull KParameter param, @NotNull String fieldName, @NotNull Codec<Object> codec) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            this.param = param;
            this.fieldName = fieldName;
            this.codec = codec;
        }

        @NotNull
        public final KParameter getParam() {
            return this.param;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        @NotNull
        public final Codec<Object> getCodec() {
            return this.codec;
        }

        @NotNull
        public final KParameter component1() {
            return this.param;
        }

        @NotNull
        public final String component2() {
            return this.fieldName;
        }

        @NotNull
        public final Codec<Object> component3() {
            return this.codec;
        }

        @NotNull
        public final PropertyModel copy(@NotNull KParameter param, @NotNull String fieldName, @NotNull Codec<Object> codec) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            return new PropertyModel(param, fieldName, codec);
        }

        public static /* synthetic */ PropertyModel copy$default(PropertyModel propertyModel, KParameter kParameter, String string, Codec codec, int n, Object object) {
            if ((n & 1) != 0) {
                kParameter = propertyModel.param;
            }
            if ((n & 2) != 0) {
                string = propertyModel.fieldName;
            }
            if ((n & 4) != 0) {
                codec = propertyModel.codec;
            }
            return propertyModel.copy(kParameter, string, codec);
        }

        @NotNull
        public String toString() {
            return "PropertyModel(param=" + this.param + ", fieldName=" + this.fieldName + ", codec=" + this.codec + ')';
        }

        public int hashCode() {
            int result = this.param.hashCode();
            result = result * 31 + this.fieldName.hashCode();
            result = result * 31 + this.codec.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyModel)) {
                return false;
            }
            PropertyModel propertyModel = (PropertyModel)other;
            if (!Intrinsics.areEqual((Object)this.param, (Object)propertyModel.param)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldName, (Object)propertyModel.fieldName)) {
                return false;
            }
            return Intrinsics.areEqual(this.codec, propertyModel.codec);
        }
    }
}

