/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlinx;

import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonType;
import org.bson.UuidRepresentation;
import org.bson.codecs.kotlinx.BsonConfiguration;
import org.bson.codecs.kotlinx.BsonDecoder;
import org.bson.codecs.kotlinx.utils.BsonCodecUtils;
import org.bson.internal.UuidHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/bson/codecs/kotlinx/JsonBsonDecoder;", "Lorg/bson/codecs/kotlinx/BsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "configuration", "Lorg/bson/codecs/kotlinx/BsonConfiguration;", "getConfiguration", "()Lorg/bson/codecs/kotlinx/BsonConfiguration;", "reader", "Lorg/bson/AbstractBsonReader;", "getReader", "()Lorg/bson/AbstractBsonReader;", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "json", "Lkotlinx/serialization/json/Json;", "readJsonArray", "Lkotlinx/serialization/json/JsonArray;", "readJsonObject", "Lkotlinx/serialization/json/JsonObject;", "bson-kotlinx"})
public interface JsonBsonDecoder
extends BsonDecoder,
JsonDecoder {
    @NotNull
    public AbstractBsonReader getReader();

    @NotNull
    public BsonConfiguration getConfiguration();

    @NotNull
    public Json json();

    @NotNull
    public JsonElement decodeJsonElement();

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nJsonBsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonBsonDecoder.kt\norg/bson/codecs/kotlinx/JsonBsonDecoder$DefaultImpls\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,155:1\n27#2,4:156\n50#2,4:160\n*S KotlinDebug\n*F\n+ 1 JsonBsonDecoder.kt\norg/bson/codecs/kotlinx/JsonBsonDecoder$DefaultImpls\n*L\n85#1:156,4\n99#1:160,4\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Json json(@NotNull JsonBsonDecoder $this) {
            return JsonKt.Json$default(null, (Function1)((Function1)new Function1<JsonBuilder, Unit>($this){
                final /* synthetic */ JsonBsonDecoder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull JsonBuilder $this$Json) {
                    Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
                    $this$Json.setExplicitNulls(this.this$0.getConfiguration().getExplicitNulls());
                    $this$Json.setEncodeDefaults(this.this$0.getConfiguration().getEncodeDefaults());
                    $this$Json.setClassDiscriminator(this.this$0.getConfiguration().getClassDiscriminator());
                    $this$Json.setNamingStrategy(BsonCodecUtils.INSTANCE.toJsonNamingStrategy$bson_kotlinx(this.this$0.getConfiguration().getBsonNamingStrategy()));
                    $this$Json.setSerializersModule(this.this$0.getSerializersModule());
                }
            }), (int)1, null);
        }

        @NotNull
        public static JsonElement decodeJsonElement(@NotNull JsonBsonDecoder $this) {
            JsonElement jsonElement;
            AbstractBsonReader $this$decodeJsonElement_u24lambda_u240 = $this.getReader();
            boolean bl = false;
            BsonType bsonType = $this$decodeJsonElement_u24lambda_u240.getCurrentBsonType();
            switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    jsonElement = (JsonElement)DefaultImpls.readJsonObject($this);
                    break;
                }
                case 2: {
                    jsonElement = (JsonElement)DefaultImpls.readJsonArray($this);
                    break;
                }
                case 3: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Void)$this.decodeNull());
                    break;
                }
                case 4: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((String)$this.decodeString());
                    break;
                }
                case 5: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Boolean)$this.decodeBoolean());
                    break;
                }
                case 6: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)$this.decodeInt());
                    break;
                }
                case 7: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)$this.decodeLong());
                    break;
                }
                case 8: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)$this.decodeDouble());
                    break;
                }
                case 9: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)((Number)$this.getReader().readDecimal128()));
                    break;
                }
                case 10: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((String)$this.decodeObjectId().toHexString());
                    break;
                }
                case 11: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)$this.getReader().readDateTime());
                    break;
                }
                case 12: {
                    jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)$this.getReader().readTimestamp().getValue());
                    break;
                }
                case 13: {
                    byte subtype = $this.getReader().peekBinarySubType();
                    byte[] data = $this.getReader().readBinaryData().getData();
                    byte by = subtype;
                    jsonElement = (JsonElement)(by == BsonBinarySubType.UUID_LEGACY.getValue() ? JsonElementKt.JsonPrimitive((String)UuidHelper.decodeBinaryToUuid((byte[])data, (byte)subtype, (UuidRepresentation)UuidRepresentation.JAVA_LEGACY).toString()) : (by == BsonBinarySubType.UUID_STANDARD.getValue() ? JsonElementKt.JsonPrimitive((String)UuidHelper.decodeBinaryToUuid((byte[])data, (byte)subtype, (UuidRepresentation)UuidRepresentation.STANDARD).toString()) : JsonElementKt.JsonPrimitive((String)Base64.getEncoder().encodeToString(data))));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported json type: " + $this$decodeJsonElement_u24lambda_u240.getCurrentBsonType()).toString());
                }
            }
            return jsonElement;
        }

        private static JsonObject readJsonObject(JsonBsonDecoder $this) {
            JsonObjectBuilder builder$iv;
            $this.getReader().readStartDocument();
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$readJsonObject_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            BsonType type = $this.getReader().readBsonType();
            while (type != BsonType.END_OF_DOCUMENT) {
                String string = $this.getReader().readName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.readName()");
                $this$readJsonObject_u24lambda_u241.put(string, $this.decodeJsonElement());
                type = $this.getReader().readBsonType();
            }
            JsonObject obj = builder$iv.build();
            $this.getReader().readEndDocument();
            return obj;
        }

        private static JsonArray readJsonArray(JsonBsonDecoder $this) {
            JsonArrayBuilder builder$iv;
            $this.getReader().readStartArray();
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder $this$readJsonArray_u24lambda_u242 = builder$iv = new JsonArrayBuilder();
            boolean bl = false;
            BsonType type = $this.getReader().readBsonType();
            while (type != BsonType.END_OF_DOCUMENT) {
                $this$readJsonArray_u24lambda_u242.add($this.decodeJsonElement());
                type = $this.getReader().readBsonType();
            }
            JsonArray array = builder$iv.build();
            $this.getReader().readEndArray();
            return array;
        }

        @ExperimentalSerializationApi
        @Nullable
        public static <T> T decodeNullableSerializableValue(@NotNull JsonBsonDecoder $this, @NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return BsonDecoder.DefaultImpls.decodeNullableSerializableValue($this, deserializer);
        }

        public static <T> T decodeSerializableValue(@NotNull JsonBsonDecoder $this, @NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return BsonDecoder.DefaultImpls.decodeSerializableValue($this, deserializer);
        }

        public static int decodeCollectionSize(@NotNull JsonBsonDecoder $this, @NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return BsonDecoder.DefaultImpls.decodeCollectionSize($this, descriptor);
        }

        @ExperimentalSerializationApi
        public static boolean decodeSequentially(@NotNull JsonBsonDecoder $this) {
            return BsonDecoder.DefaultImpls.decodeSequentially($this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            try {
                nArray[BsonType.DOCUMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT64.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DECIMAL128.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.OBJECT_ID.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DATE_TIME.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.TIMESTAMP.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BINARY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

