/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.cdc.CdcHandler;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.debezium.OperationType;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public abstract class DebeziumCdcHandler
extends CdcHandler {
    private static final String OPERATION_TYPE_FIELD_PATH = "op";
    private final Map<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();

    public DebeziumCdcHandler(MongoSinkTopicConfig config) {
        super(config);
    }

    protected void registerOperations(Map<OperationType, CdcOperation> operations) {
        this.operations.putAll(operations);
    }

    public CdcOperation getCdcOperation(BsonDocument doc) {
        try {
            if (!doc.containsKey((Object)OPERATION_TYPE_FIELD_PATH) || !doc.get((Object)OPERATION_TYPE_FIELD_PATH).isString()) {
                throw new DataException("Value document is missing or CDC operation is not a string");
            }
            CdcOperation op = this.operations.get((Object)OperationType.fromText(doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue()));
            if (op == null) {
                throw new DataException("No CDC operation found in mapping for op=" + doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue());
            }
            return op;
        }
        catch (IllegalArgumentException exc) {
            throw new DataException("Parsing CDC operation failed", (Throwable)exc);
        }
    }
}

