/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class UpdateOneTimestampsStrategy
implements WriteModelStrategy {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);
    static final String FIELD_NAME_MODIFIED_TS = "_modifiedTS";
    static final String FIELD_NAME_INSERTED_TS = "_insertedTS";

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get((Object)"_id");
        if (idValue == null) {
            throw new DataException("Could not build the WriteModel,the `_id` field was missing unexpectedly");
        }
        BsonDateTime dateTime = new BsonDateTime(System.currentTimeMillis());
        return new UpdateOneModel((Bson)new BsonDocument("_id", idValue), (Bson)new BsonDocument("$set", (BsonValue)vd.append(FIELD_NAME_MODIFIED_TS, (BsonValue)dateTime)).append("$setOnInsert", (BsonValue)new BsonDocument(FIELD_NAME_INSERTED_TS, (BsonValue)dateTime)), UPDATE_OPTIONS);
    }
}

