/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonValue;

final class WriteModelHelper {
    private static final String CREATE_PREFIX = "%s%s.";
    private static final String ELEMENT_NAME_PREFIX = "%s%s";

    static BsonDocument flattenKeys(BsonDocument original) {
        BsonDocument businessKey = new BsonDocument();
        original.forEach((key, value) -> WriteModelHelper.flattenBsonElement("", new BsonElement(key, value)).forEach(b -> businessKey.append(b.getName(), b.getValue())));
        return businessKey;
    }

    static List<BsonElement> flattenBsonElement(String prefix, BsonElement element) {
        if (element.getValue().isDocument()) {
            return element.getValue().asDocument().entrySet().stream().flatMap(e -> WriteModelHelper.flattenBsonElement(String.format(CREATE_PREFIX, prefix, element.getName()), new BsonElement((String)e.getKey(), (BsonValue)e.getValue())).stream()).collect(Collectors.toList());
        }
        return Collections.singletonList(new BsonElement(String.format(ELEMENT_NAME_PREFIX, prefix, element.getName()), element.getValue()));
    }

    private WriteModelHelper() {
    }
}

