/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.changestream.ChangeStreamDocumentCodec;
import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.client.model.changestream.UpdateDescription;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class ChangeStreamDocument<TDocument> {
    @BsonId
    private final BsonDocument resumeToken;
    private final BsonDocument namespaceDocument;
    private final TDocument fullDocument;
    private final BsonDocument documentKey;
    private final BsonTimestamp clusterTime;
    private final OperationType operationType;
    private final UpdateDescription updateDescription;

    @Deprecated
    public ChangeStreamDocument(BsonDocument resumeToken, MongoNamespace namespace, TDocument fullDocument, BsonDocument documentKey, OperationType operationType, UpdateDescription updateDescription) {
        this(resumeToken, namespace, fullDocument, documentKey, null, operationType, updateDescription);
    }

    @Deprecated
    public ChangeStreamDocument(BsonDocument resumeToken, MongoNamespace namespace, TDocument fullDocument, BsonDocument documentKey, @Nullable BsonTimestamp clusterTime, OperationType operationType, UpdateDescription updateDescription) {
        this(resumeToken, ChangeStreamDocument.namespaceToDocument(namespace), fullDocument, documentKey, clusterTime, operationType, updateDescription);
    }

    @BsonCreator
    public ChangeStreamDocument(@BsonProperty(value="resumeToken") BsonDocument resumeToken, @BsonProperty(value="ns") BsonDocument namespaceDocument, @BsonProperty(value="fullDocument") TDocument fullDocument, @BsonProperty(value="documentKey") BsonDocument documentKey, @Nullable @BsonProperty(value="clusterTime") BsonTimestamp clusterTime, @BsonProperty(value="operationType") OperationType operationType, @BsonProperty(value="updateDescription") UpdateDescription updateDescription) {
        this.resumeToken = resumeToken;
        this.namespaceDocument = namespaceDocument;
        this.documentKey = documentKey;
        this.fullDocument = fullDocument;
        this.clusterTime = clusterTime;
        this.operationType = operationType;
        this.updateDescription = updateDescription;
    }

    private static BsonDocument namespaceToDocument(MongoNamespace namespace) {
        Assertions.notNull("namespace", namespace);
        return new BsonDocument("db", new BsonString(namespace.getDatabaseName())).append("coll", new BsonString(namespace.getCollectionName()));
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    @BsonIgnore
    @Nullable
    public MongoNamespace getNamespace() {
        if (this.namespaceDocument == null) {
            return null;
        }
        if (!this.namespaceDocument.containsKey("db") || !this.namespaceDocument.containsKey("coll")) {
            return null;
        }
        return new MongoNamespace(this.namespaceDocument.getString("db").getValue(), this.namespaceDocument.getString("coll").getValue());
    }

    @BsonProperty(value="ns")
    public BsonDocument getNamespaceDocument() {
        return this.namespaceDocument;
    }

    @BsonIgnore
    @Nullable
    public String getDatabaseName() {
        if (this.namespaceDocument == null) {
            return null;
        }
        if (!this.namespaceDocument.containsKey("db")) {
            return null;
        }
        return this.namespaceDocument.getString("db").getValue();
    }

    @Nullable
    public TDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getDocumentKey() {
        return this.documentKey;
    }

    @Nullable
    public BsonTimestamp getClusterTime() {
        return this.clusterTime;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public UpdateDescription getUpdateDescription() {
        return this.updateDescription;
    }

    public static <TFullDocument> Codec<ChangeStreamDocument<TFullDocument>> createCodec(Class<TFullDocument> fullDocumentClass, CodecRegistry codecRegistry) {
        return new ChangeStreamDocumentCodec<TFullDocument>(fullDocumentClass, codecRegistry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeStreamDocument that = (ChangeStreamDocument)o;
        if (this.resumeToken != null ? !this.resumeToken.equals(that.resumeToken) : that.resumeToken != null) {
            return false;
        }
        if (this.namespaceDocument != null ? !this.namespaceDocument.equals(that.namespaceDocument) : that.namespaceDocument != null) {
            return false;
        }
        if (this.fullDocument != null ? !this.fullDocument.equals(that.fullDocument) : that.fullDocument != null) {
            return false;
        }
        if (this.documentKey != null ? !this.documentKey.equals(that.documentKey) : that.documentKey != null) {
            return false;
        }
        if (this.clusterTime != null ? !this.clusterTime.equals(that.clusterTime) : that.clusterTime != null) {
            return false;
        }
        if (this.operationType != that.operationType) {
            return false;
        }
        return !(this.updateDescription != null ? !this.updateDescription.equals(that.updateDescription) : that.updateDescription != null);
    }

    public int hashCode() {
        int result = this.resumeToken != null ? this.resumeToken.hashCode() : 0;
        result = 31 * result + (this.namespaceDocument != null ? this.namespaceDocument.hashCode() : 0);
        result = 31 * result + (this.fullDocument != null ? this.fullDocument.hashCode() : 0);
        result = 31 * result + (this.documentKey != null ? this.documentKey.hashCode() : 0);
        result = 31 * result + (this.clusterTime != null ? this.clusterTime.hashCode() : 0);
        result = 31 * result + (this.operationType != null ? this.operationType.hashCode() : 0);
        result = 31 * result + (this.updateDescription != null ? this.updateDescription.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ChangeStreamDocument{resumeToken=" + this.resumeToken + ", namespace=" + this.getNamespace() + ", fullDocument=" + this.fullDocument + ", documentKey=" + this.documentKey + ", clusterTime=" + this.clusterTime + ", operationType=" + (Object)((Object)this.operationType) + ", updateDescription=" + this.updateDescription + "}";
    }
}

