/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import org.bson.BsonTimestamp;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = ((AsyncClusterAwareReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped)).retain();
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((SingleResultCallback<Boolean>)((SingleResultCallback)(isConnectionSourcePinningRequired, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(true, callback);
            } else {
                this.wrapped.getReadConnectionSource((SingleResultCallback)new WrappingCallback(callback));
            }
        }));
    }

    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((SingleResultCallback<Boolean>)((SingleResultCallback)(isConnectionSourcePinningRequired, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(false, callback);
            } else {
                this.wrapped.getWriteConnectionSource((SingleResultCallback)new WrappingCallback(callback));
            }
        }));
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    private void getPinnedConnectionSource(boolean isRead, SingleResultCallback<AsyncConnectionSource> callback) {
        WrappingCallback wrappingCallback = new WrappingCallback(callback);
        TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)this.session);
        if (transactionContext == null) {
            SingleResultCallback connectionSourceCallback = (result, t) -> {
                if (t != null) {
                    wrappingCallback.onResult(null, t);
                } else {
                    TransactionContext newTransactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
                    this.session.setTransactionContext(result.getServerDescription().getAddress(), newTransactionContext);
                    newTransactionContext.release();
                    wrappingCallback.onResult((AsyncConnectionSource)result, (Throwable)null);
                }
            };
            if (isRead) {
                this.wrapped.getReadConnectionSource(connectionSourceCallback);
            } else {
                this.wrapped.getWriteConnectionSource(connectionSourceCallback);
            }
        } else {
            this.wrapped.getConnectionSource((ServerAddress)Assertions.assertNotNull((Object)this.session.getPinnedServerAddress()), (SingleResultCallback)new WrappingCallback(callback));
        }
    }

    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, callback);
    }

    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    private void isConnectionSourcePinningRequired(SingleResultCallback<Boolean> callback) {
        try {
            callback.onResult((Object)this.isConnectionSourcePinningRequired(), null);
        }
        catch (Exception e) {
            callback.onResult(null, (Throwable)e);
        }
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        AsyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean isSnapshot() {
            Boolean snapshot = this.clientSession.getOptions().isSnapshot();
            return snapshot != null && snapshot != false;
        }

        public void setSnapshotTimestamp(@Nullable BsonTimestamp snapshotTimestamp) {
            this.clientSession.setSnapshotTimestamp(snapshotTimestamp);
        }

        @Nullable
        public BsonTimestamp getSnapshotTimestamp() {
            return this.clientSession.getSnapshotTimestamp();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return (ReadConcern)Assertions.assertNotNull((Object)this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        public void onResult(@Nullable AsyncConnectionSource result, @Nullable Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult((Object)new SessionBindingAsyncConnectionSource((AsyncConnectionSource)Assertions.assertNotNull((Object)result)), null);
            }
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Nullable
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                AsyncConnection pinnedConnection = (AsyncConnection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    this.wrapped.getConnection((connection, t) -> {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            transactionContext.pinConnection((ReferenceCounted)connection, AsyncConnection::markAsPinned);
                            callback.onResult(connection, null);
                        }
                    });
                } else {
                    callback.onResult((Object)pinnedConnection.retain(), null);
                }
            } else {
                this.wrapped.getConnection(callback);
            }
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

