/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.ClientMetadataHelper;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.mongodb.reactivestreams.client.internal.ListDatabasesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoDatabaseImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.mongodb.reactivestreams.client.internal.OperationExecutorImpl;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.Crypts;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final OperationExecutor executor;
    private final Closeable externalResourceCloser;
    private final ServerSessionPool serverSessionPool;
    private final ClientSessionHelper clientSessionHelper;
    private final MongoOperationPublisher<Document> mongoOperationPublisher;
    private final Crypt crypt;
    private final AtomicBoolean closed;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable Closeable externalResourceCloser) {
        this(settings, mongoDriverInformation, cluster, null, externalResourceCloser);
    }

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor) {
        this(settings, mongoDriverInformation, cluster, executor, null);
    }

    private MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor, @Nullable Closeable externalResourceCloser) {
        this.settings = (MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings);
        this.cluster = (Cluster)Assertions.notNull((String)"cluster", (Object)cluster);
        this.serverSessionPool = new ServerSessionPool(cluster, settings.getServerApi());
        this.clientSessionHelper = new ClientSessionHelper(this, this.serverSessionPool);
        AutoEncryptionSettings autoEncryptSettings = settings.getAutoEncryptionSettings();
        this.crypt = autoEncryptSettings != null ? Crypts.createCrypt(this, autoEncryptSettings) : null;
        this.executor = executor == null ? new OperationExecutorImpl(this, this.clientSessionHelper) : executor;
        this.externalResourceCloser = externalResourceCloser;
        this.mongoOperationPublisher = new MongoOperationPublisher<Document>(Document.class, CodecRegistries.withUuidRepresentation((CodecRegistry)settings.getCodecRegistry(), (UuidRepresentation)settings.getUuidRepresentation()), settings.getReadPreference(), settings.getReadConcern(), settings.getWriteConcern(), settings.getRetryWrites(), settings.getRetryReads(), settings.getUuidRepresentation(), this.executor);
        this.closed = new AtomicBoolean();
        LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", ClientMetadataHelper.createClientMetadataDocument((String)settings.getApplicationName(), (MongoDriverInformation)mongoDriverInformation).toJson(), settings));
    }

    Cluster getCluster() {
        return this.cluster;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    MongoOperationPublisher<Document> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    @Nullable
    Crypt getCrypt() {
        return this.crypt;
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withDatabase(name));
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.crypt != null) {
                this.crypt.close();
            }
            this.serverSessionPool.close();
            this.cluster.close();
            if (this.externalResourceCloser != null) {
                try {
                    this.externalResourceCloser.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception closing resource", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return Flux.from(this.listDatabases().nameOnly(true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return Flux.from(this.listDatabases(clientSession).nameOnly(true)).map(d -> d.getString((Object)"name"));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>(null, this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    public <T> ChangeStreamPublisher<T> watch(Class<T> resultClass) {
        return this.watch((List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>(null, this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, Class<T> resultClass) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public Publisher<ClientSession> startSession() {
        return this.startSession(ClientSessionOptions.builder().build());
    }

    @Override
    public Publisher<ClientSession> startSession(ClientSessionOptions options) {
        return this.clientSessionHelper.createClientSessionMono((ClientSessionOptions)Assertions.notNull((String)"options", (Object)options), this.executor).switchIfEmpty(Mono.create(sink -> sink.error((Throwable)new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected"))));
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.getCluster().getCurrentDescription();
    }
}

