/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.internal.TimeoutHelper;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class KeyRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Key retrieval exceeded the timeout limit.";
    private final MongoClient client;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient client, MongoNamespace namespace) {
        this.client = (MongoClient)Assertions.notNull((String)"client", (Object)client);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
    }

    public Mono<List<BsonDocument>> find(BsonDocument keyFilter, @Nullable Timeout operationTimeout) {
        return Flux.defer(() -> {
            MongoCollection<BsonDocument> collection = this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class);
            return TimeoutHelper.collectionWithTimeout(collection, operationTimeout, TIMEOUT_ERROR_MESSAGE).withReadConcern(ReadConcern.MAJORITY).find((Bson)keyFilter);
        }).collectList();
    }
}

