/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class ClassHelper {
    private static final Class<?>[] MONGO_CONFIG_PARAMETER_TYPES = new Class[]{MongoConfig.class};

    static <T> T createInstance(String configKey, String className, Class<T> clazz, MongoConfig mongoConfig) {
        return (T)ClassHelper.createInstance(configKey, className, clazz, () -> {
            Class<?> concreteClass = Class.forName(className);
            Optional<Constructor> mongoConfigConstructor = Arrays.stream(concreteClass.getConstructors()).filter(c -> Arrays.equals(c.getParameterTypes(), MONGO_CONFIG_PARAMETER_TYPES)).findFirst();
            if (mongoConfigConstructor.isPresent()) {
                return mongoConfigConstructor.get().newInstance(mongoConfig);
            }
            return concreteClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        });
    }

    private static <T> T createInstance(String configKey, String className, Class<T> clazz, ClassCreator<T> cc) {
        try {
            return cc.init();
        }
        catch (ClassCastException e) {
            throw new ConfigException(configKey, className, String.format("Contract violation class doesn't implement: '%s'", clazz.getSimpleName()));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(configKey, className, String.format("Class not found: %s", e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            throw new ConfigException(configKey, className, String.format("Class could not be initialized, no public constructor available: %s", e.getMessage()));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConfigException) {
                throw (ConfigException)e.getCause();
            }
            throw new ConfigException(configKey, className, e.getMessage());
        }
    }

    private ClassHelper() {
    }

    @FunctionalInterface
    static interface ClassCreator<T> {
        public T init() throws Exception;
    }
}

