/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoPartitionReaderFactory;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.types.StructType;

public class MongoBatch
implements Batch {
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;

    public MongoBatch(StructType schema, ReadConfig readConfig) {
        this.bsonDocumentToRowConverter = new BsonDocumentToRowConverter(schema);
        this.readConfig = readConfig;
    }

    public InputPartition[] planInputPartitions() {
        return PartitionerHelper.generatePartitions(this.readConfig);
    }

    public PartitionReaderFactory createReaderFactory() {
        return new MongoPartitionReaderFactory(this.bsonDocumentToRowConverter, this.readConfig);
    }
}

