/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoScan;
import com.mongodb.spark.sql.connector.schema.RowToBsonDocumentConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;

public class MongoScanBuilder
implements ScanBuilder,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final StructType schema;
    private final ReadConfig readConfig;
    private final boolean isCaseSensitive;
    private List<BsonDocument> datasetAggregationPipeline;
    private Filter[] pushedFilters;
    private StructType prunedSchema;

    public MongoScanBuilder(StructType schema, ReadConfig readConfig) {
        this.schema = schema;
        this.readConfig = readConfig;
        this.prunedSchema = schema;
        this.isCaseSensitive = (Boolean)SparkSession.getActiveSession().map(s -> s.sessionState().conf().caseSensitiveAnalysis()).getOrElse(() -> false);
        this.datasetAggregationPipeline = Collections.emptyList();
        this.pushedFilters = new Filter[0];
    }

    public Scan build() {
        ArrayList<BsonDocument> scanAggregationPipeline = new ArrayList<BsonDocument>();
        scanAggregationPipeline.addAll(this.readConfig.getAggregationPipeline());
        scanAggregationPipeline.addAll(this.datasetAggregationPipeline);
        ReadConfig scanReadConfig = this.readConfig.withOption("spark.mongodb.read.aggregation.pipeline", scanAggregationPipeline.stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]")));
        return new MongoScan(this.prunedSchema, scanReadConfig);
    }

    public Filter[] pushFilters(Filter[] filters) {
        List processed = Arrays.stream(filters).map(this::processFilter).collect(Collectors.toList());
        List withPipelines = processed.stream().filter(FilterAndPipelineStage::hasPipelineStage).collect(Collectors.toList());
        this.datasetAggregationPipeline = withPipelines.isEmpty() ? Collections.emptyList() : Collections.singletonList(Aggregates.match((Bson)Filters.and((Iterable)withPipelines.stream().map(FilterAndPipelineStage::getPipelineStage).collect(Collectors.toList()))).toBsonDocument());
        this.pushedFilters = (Filter[])withPipelines.stream().map(FilterAndPipelineStage::getFilter).toArray(Filter[]::new);
        return (Filter[])processed.stream().filter(e -> !e.hasPipelineStage()).map(FilterAndPipelineStage::getFilter).toArray(Filter[]::new);
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public void pruneColumns(StructType requiredSchema) {
        Set requiredColumns = Arrays.stream(requiredSchema.fields()).map(this::getColumnName).collect(Collectors.toSet());
        StructField[] fields = (StructField[])Arrays.stream(this.schema.fields()).filter(f -> requiredColumns.contains(this.getColumnName((StructField)f))).toArray(StructField[]::new);
        this.prunedSchema = new StructType(fields);
    }

    private String getColumnName(StructField field) {
        if (this.isCaseSensitive) {
            return field.name().toLowerCase(Locale.ROOT);
        }
        return field.name();
    }

    private FilterAndPipelineStage processFilter(Filter filter) {
        Assertions.ensureArgument(() -> filter != null, () -> "Invalid argument filter cannot be null");
        if (filter instanceof And) {
            And andFilter = (And)filter;
            FilterAndPipelineStage eitherLeft = this.processFilter(andFilter.left());
            FilterAndPipelineStage eitherRight = this.processFilter(andFilter.right());
            if (eitherLeft.hasPipelineStage() && eitherRight.hasPipelineStage()) {
                return new FilterAndPipelineStage(filter, Filters.and((Bson[])new Bson[]{eitherLeft.getPipelineStage(), eitherRight.getPipelineStage()}));
            }
        } else {
            if (filter instanceof EqualNullSafe) {
                EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
                return new FilterAndPipelineStage(filter, Filters.eq((String)equalNullSafe.attribute(), (Object)this.processValue(equalNullSafe.attribute(), equalNullSafe.value())));
            }
            if (filter instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)filter;
                return new FilterAndPipelineStage(filter, Filters.eq((String)equalTo.attribute(), (Object)this.processValue(equalTo.attribute(), equalTo.value())));
            }
            if (filter instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)filter;
                return new FilterAndPipelineStage(filter, Filters.gt((String)greaterThan.attribute(), (Object)this.processValue(greaterThan.attribute(), greaterThan.value())));
            }
            if (filter instanceof GreaterThanOrEqual) {
                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
                return new FilterAndPipelineStage(filter, Filters.gte((String)greaterThanOrEqual.attribute(), (Object)this.processValue(greaterThanOrEqual.attribute(), greaterThanOrEqual.value())));
            }
            if (filter instanceof In) {
                In inFilter = (In)filter;
                Bson pipelineStage = Filters.in((String)inFilter.attribute(), (Iterable)Arrays.stream(inFilter.values()).map(v -> this.processValue(inFilter.attribute(), v)).collect(Collectors.toList()));
                return new FilterAndPipelineStage(filter, pipelineStage);
            }
            if (filter instanceof IsNull) {
                IsNull isNullFilter = (IsNull)filter;
                return new FilterAndPipelineStage(filter, Filters.eq((String)isNullFilter.attribute(), null));
            }
            if (filter instanceof LessThan) {
                LessThan lessThan = (LessThan)filter;
                return new FilterAndPipelineStage(filter, Filters.lt((String)lessThan.attribute(), (Object)this.processValue(lessThan.attribute(), lessThan.value())));
            }
            if (filter instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
                return new FilterAndPipelineStage(filter, Filters.lte((String)lessThanOrEqual.attribute(), (Object)this.processValue(lessThanOrEqual.attribute(), lessThanOrEqual.value())));
            }
            if (filter instanceof Not) {
                Not notFilter = (Not)filter;
                FilterAndPipelineStage notChild = this.processFilter(notFilter.child());
                if (notChild.hasPipelineStage()) {
                    return new FilterAndPipelineStage(filter, Filters.not((Bson)notChild.pipelineStage));
                }
            } else if (filter instanceof Or) {
                Or or = (Or)filter;
                FilterAndPipelineStage eitherLeft = this.processFilter(or.left());
                FilterAndPipelineStage eitherRight = this.processFilter(or.right());
                if (eitherLeft.hasPipelineStage() && eitherRight.hasPipelineStage()) {
                    return new FilterAndPipelineStage(filter, Filters.or((Bson[])new Bson[]{eitherLeft.getPipelineStage(), eitherRight.getPipelineStage()}));
                }
            } else {
                if (filter instanceof StringContains) {
                    StringContains stringContains = (StringContains)filter;
                    return new FilterAndPipelineStage(filter, Filters.regex((String)stringContains.attribute(), (String)String.format(".*%s.*", stringContains.value())));
                }
                if (filter instanceof StringEndsWith) {
                    StringEndsWith stringEndsWith = (StringEndsWith)filter;
                    return new FilterAndPipelineStage(filter, Filters.regex((String)stringEndsWith.attribute(), (String)String.format(".*%s$", stringEndsWith.value())));
                }
                if (filter instanceof StringStartsWith) {
                    StringStartsWith stringStartsWith = (StringStartsWith)filter;
                    return new FilterAndPipelineStage(filter, Filters.regex((String)stringStartsWith.attribute(), (String)String.format("^%s.*", stringStartsWith.value())));
                }
            }
        }
        return new FilterAndPipelineStage(filter, null);
    }

    private Object processValue(String fieldName, Object value) {
        return RowToBsonDocumentConverter.toBsonValue(this.schema.apply(fieldName).dataType(), value);
    }

    private static final class FilterAndPipelineStage {
        private final Filter filter;
        private final Bson pipelineStage;

        private FilterAndPipelineStage(Filter filter, @Nullable Bson pipelineStage) {
            this.filter = filter;
            this.pipelineStage = pipelineStage;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Bson getPipelineStage() {
            return this.pipelineStage;
        }

        boolean hasPipelineStage() {
            return this.pipelineStage != null;
        }
    }
}

