/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.MongoPartitionReader;
import com.mongodb.spark.sql.connector.read.ResumeTokenPartitionOffset;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStreamPartitionReader
implements ContinuousPartitionReader<InternalRow> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPartitionReader.class);
    private static final String FULL_DOCUMENT = "fullDocument";
    private final MongoInputPartition partition;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;
    private ResumeTokenPartitionOffset lastOffset;
    private InternalRow currentRow;
    private boolean closed = false;
    private MongoClient mongoClient;
    private MongoChangeStreamCursor<BsonDocument> changeStreamCursor;

    public MongoStreamPartitionReader(MongoInputPartition partition, BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.partition = partition;
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
        this.currentRow = null;
        this.lastOffset = partition.getResumeTokenPartitionOffset();
        LOGGER.debug("Creating partition reader for: Partition: {} with Schema: {}", (Object)partition, (Object)bsonDocumentToRowConverter);
    }

    public PartitionOffset getOffset() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call getOffset() on a closed PartitionReader.");
        LOGGER.trace("getOffset called, returning: {}", (Object)this.lastOffset);
        return this.lastOffset;
    }

    public boolean next() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call next() on a closed PartitionReader.");
        boolean hasNext = false;
        while (!hasNext) {
            hasNext = this.tryNext();
        }
        return true;
    }

    public InternalRow get() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call get() on a closed PartitionReader.");
        Assertions.ensureState(() -> this.currentRow != null, () -> "Current row is null, this should not happen if `next()` returns true.");
        LOGGER.trace("Get called: {}", (Object)this.currentRow);
        return this.currentRow;
    }

    public void close() {
        LOGGER.info("Closing the stream partition reader.");
        if (!this.closed) {
            this.closed = true;
            this.releaseCursorAndClient();
        }
    }

    private boolean tryNext() {
        return this.withCursor(c -> {
            try {
                if (c.hasNext()) {
                    BsonDocument next = (BsonDocument)c.next();
                    this.lastOffset = new ResumeTokenPartitionOffset(c.getResumeToken());
                    if (this.readConfig.streamPublishFullDocumentOnly()) {
                        next = next.getDocument((Object)FULL_DOCUMENT, new BsonDocument());
                    }
                    this.currentRow = this.bsonDocumentToRowConverter.toInternalRow(next);
                    return true;
                }
            }
            catch (MongoException e) {
                LOGGER.info("Trying to get more data from the change stream failed, releasing cursor.", (Throwable)e);
            }
            this.releaseCursorAndClient();
            this.currentRow = null;
            return false;
        });
    }

    private MongoChangeStreamCursor<BsonDocument> getCursor() {
        if (this.mongoClient == null) {
            this.mongoClient = this.readConfig.getMongoClient();
        }
        if (this.changeStreamCursor == null) {
            ArrayList<BsonDocument> pipeline = new ArrayList<BsonDocument>();
            if (this.readConfig.streamPublishFullDocumentOnly()) {
                pipeline.add(Aggregates.match((Bson)Filters.exists((String)FULL_DOCUMENT)).toBsonDocument());
            }
            pipeline.addAll(this.partition.getPipeline());
            ChangeStreamIterable changeStreamIterable = this.mongoClient.getDatabase(this.readConfig.getDatabaseName()).getCollection(this.readConfig.getCollectionName()).watch(pipeline).fullDocument(this.readConfig.getStreamFullDocument());
            if (!this.lastOffset.getResumeToken().isEmpty()) {
                changeStreamIterable = changeStreamIterable.startAfter(this.lastOffset.getResumeToken());
            }
            try {
                this.changeStreamCursor = (MongoChangeStreamCursor)changeStreamIterable.withDocumentClass(BsonDocument.class).cursor();
                LOGGER.debug("Opened change stream cursor for partition: {}", (Object)this.partition);
            }
            catch (RuntimeException e) {
                throw new MongoSparkException("Could not create the change stream cursor.", e);
            }
        }
        return this.changeStreamCursor;
    }

    private <T> T withCursor(Function<MongoChangeStreamCursor<BsonDocument>, T> cursorConsumer) {
        try {
            return cursorConsumer.apply(this.getCursor());
        }
        catch (MongoInterruptedException e) {
            this.releaseCursor();
            throw new MongoSparkException("Change stream cursor interrupted.");
        }
        catch (MongoException e) {
            this.releaseCursor();
            throw new MongoSparkException("Change stream cursor failure.", e);
        }
    }

    private void releaseCursorAndClient() {
        try {
            this.releaseCursor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.releaseClient();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void releaseCursor() {
        if (this.changeStreamCursor != null) {
            LOGGER.debug("Releasing change stream cursor for partition: {}", (Object)this.partition);
            try {
                this.changeStreamCursor.close();
            }
            finally {
                this.changeStreamCursor = null;
            }
        }
    }

    private void releaseClient() {
        if (this.changeStreamCursor != null) {
            LOGGER.debug("Releasing mongoClient for partition: {}", (Object)this.partition);
            try {
                this.mongoClient.close();
            }
            finally {
                this.mongoClient = null;
            }
        }
    }
}

