/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.MongoStreamPartitionReader;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoStreamPartitionReaderFactory
implements ContinuousPartitionReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoStreamPartitionReaderFactory.class);
    private static final long serialVersionUID = 1L;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;

    public MongoStreamPartitionReaderFactory(BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
    }

    public ContinuousPartitionReader<InternalRow> createReader(InputPartition partition) {
        Assertions.ensureState(() -> partition instanceof MongoInputPartition, () -> String.format("Unsupported InputPartition type, a MongoInputPartition instance is required. Got: %s", partition.getClass()));
        LOGGER.debug("Creating MongoStreamPartitionReader for {}", (Object)partition);
        return new MongoStreamPartitionReader((MongoInputPartition)partition, this.bsonDocumentToRowConverter, this.readConfig);
    }
}

