/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.schema;

import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import com.mongodb.spark.sql.connector.exceptions.DataException;
import com.mongodb.spark.sql.connector.schema.InternalRowToRowFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@NotNull
public final class RowToBsonDocumentConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Function<InternalRow, Row> internalRowConverter;

    @TestOnly
    public RowToBsonDocumentConverter() {
        this((InternalRow internalRow) -> {
            throw new ConfigException("No InternalRow to Row converter");
        });
    }

    public RowToBsonDocumentConverter(StructType schema) {
        this(new InternalRowToRowFunction(schema));
    }

    private RowToBsonDocumentConverter(Function<InternalRow, Row> internalRowConverter) {
        this.internalRowConverter = internalRowConverter;
    }

    public BsonDocument fromRow(InternalRow row) {
        return this.fromRow(this.internalRowConverter.apply(row));
    }

    public BsonDocument fromRow(Row row) {
        if (row.schema() == null) {
            throw new DataException("Cannot convert Row without schema");
        }
        return RowToBsonDocumentConverter.toBsonValue((DataType)row.schema(), row).asDocument();
    }

    public static BsonValue toBsonValue(DataType dataType, Object data) {
        try {
            if (DataTypes.BinaryType.acceptsType(dataType)) {
                return new BsonBinary((byte[])data);
            }
            if (DataTypes.BooleanType.acceptsType(dataType)) {
                return new BsonBoolean(((Boolean)data).booleanValue());
            }
            if (DataTypes.DoubleType.acceptsType(dataType)) {
                return new BsonDouble(((Number)data).doubleValue());
            }
            if (DataTypes.FloatType.acceptsType(dataType)) {
                return new BsonDouble((double)((Number)data).floatValue());
            }
            if (DataTypes.IntegerType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.ShortType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.ByteType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.LongType.acceptsType(dataType)) {
                return new BsonInt64(((Number)data).longValue());
            }
            if (DataTypes.StringType.acceptsType(dataType)) {
                return new BsonString((String)data);
            }
            if (DataTypes.DateType.acceptsType(dataType) || DataTypes.TimestampType.acceptsType(dataType)) {
                if (data instanceof Date) {
                    return new BsonDateTime(((Date)data).getTime());
                }
                return new BsonDateTime(((Timestamp)data).getTime());
            }
            if (dataType instanceof DecimalType) {
                BigDecimal bigDecimal = data instanceof BigDecimal ? (BigDecimal)data : ((Decimal)data).toBigDecimal().bigDecimal();
                return new BsonDecimal128(new Decimal128(bigDecimal));
            }
            if (dataType instanceof ArrayType) {
                DataType elementType = ((ArrayType)dataType).elementType();
                BsonArray bsonArray = new BsonArray();
                List listData = data instanceof List ? (List)data : JavaConverters.seqAsJavaList((Seq)((Seq)data));
                listData.forEach(d -> bsonArray.add(RowToBsonDocumentConverter.toBsonValue(elementType, d)));
                return bsonArray;
            }
            if (dataType instanceof MapType) {
                DataType keyType = ((MapType)dataType).keyType();
                DataType valueType = ((MapType)dataType).valueType();
                if (!(keyType instanceof StringType)) {
                    throw new DataException(String.format("Cannot cast %s into a BsonValue. Invalid key type %s.", data, keyType));
                }
                BsonDocument bsonDocument = new BsonDocument();
                java.util.Map mapData = data instanceof java.util.Map ? (java.util.Map)data : JavaConverters.mapAsJavaMap((Map)((Map)data));
                mapData.forEach((k, v) -> bsonDocument.put(k, RowToBsonDocumentConverter.toBsonValue(valueType, v)));
                return bsonDocument;
            }
            if (dataType instanceof StructType) {
                Row row = (Row)data;
                BsonDocument bsonDocument = new BsonDocument();
                for (StructField field : row.schema().fields()) {
                    int fieldIndex = row.fieldIndex(field.name());
                    if (field.nullable() && row.isNullAt(fieldIndex)) continue;
                    bsonDocument.append(field.name(), RowToBsonDocumentConverter.toBsonValue(field.dataType(), row.get(fieldIndex)));
                }
                return bsonDocument;
            }
        }
        catch (Exception e) {
            throw new DataException(String.format("Cannot cast %s into a BsonValue. %s has no matching BsonValue. Error: %s", data, dataType, e.getMessage()));
        }
        throw new DataException(String.format("Cannot cast %s into a BsonValue. %s has no matching BsonValue.", data, dataType));
    }
}

