/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.write;

import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.schema.RowToBsonDocumentConverter;
import com.mongodb.spark.sql.connector.write.MongoDataWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.streaming.StreamingDataWriterFactory;

class MongoDataWriterFactory
implements DataWriterFactory,
StreamingDataWriterFactory {
    static final long serialVersionUID = 1L;
    private final RowToBsonDocumentConverter rowToBsonDocumentConverter;
    private final WriteConfig writeConfig;

    MongoDataWriterFactory(RowToBsonDocumentConverter rowToBsonDocumentConverter, WriteConfig writeConfig) {
        this.rowToBsonDocumentConverter = rowToBsonDocumentConverter;
        this.writeConfig = writeConfig;
    }

    public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
        return new MongoDataWriter(partitionId, taskId, this.rowToBsonDocumentConverter, this.writeConfig, -1L);
    }

    public DataWriter<InternalRow> createWriter(int partitionId, long taskId, long epochId) {
        return new MongoDataWriter(partitionId, taskId, this.rowToBsonDocumentConverter, this.writeConfig, epochId);
    }
}

