/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.write;

import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.schema.RowToBsonDocumentConverter;
import com.mongodb.spark.sql.connector.write.MongoBatchWrite;
import com.mongodb.spark.sql.connector.write.MongoStreamingWrite;
import java.util.Map;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.SupportsTruncate;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MongoWriteBuilder
implements WriteBuilder,
SupportsTruncate {
    private final LogicalWriteInfo info;
    private final RowToBsonDocumentConverter rowToBsonDocumentConverter;
    private final WriteConfig writeConfig;
    private final boolean truncate;

    public MongoWriteBuilder(LogicalWriteInfo info, WriteConfig writeConfig) {
        this(info, new RowToBsonDocumentConverter(info.schema()), (WriteConfig)writeConfig.withOptions((Map)info.options()), false);
    }

    public BatchWrite buildForBatch() {
        return new MongoBatchWrite(this.info, this.rowToBsonDocumentConverter, this.writeConfig, this.truncate);
    }

    public StreamingWrite buildForStreaming() {
        return new MongoStreamingWrite(this.info, this.rowToBsonDocumentConverter, this.writeConfig, this.truncate);
    }

    public WriteBuilder truncate() {
        return new MongoWriteBuilder(this.info, this.rowToBsonDocumentConverter, this.writeConfig, true);
    }

    private MongoWriteBuilder(LogicalWriteInfo info, RowToBsonDocumentConverter rowToBsonDocumentConverter, WriteConfig writeConfig, boolean truncate) {
        this.info = info;
        this.rowToBsonDocumentConverter = rowToBsonDocumentConverter;
        this.writeConfig = writeConfig;
        this.truncate = truncate;
    }
}

