/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import org.mortbay.log.Log;
import org.mortbay.util.IntrospectionUtil;

public class Injection {
    private String _className;
    private String _jndiName;
    private String _mappingName;
    private Member _target;

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String name) {
        this._className = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public String getMappingName() {
        return this._mappingName;
    }

    public void setMappingName(String mappingName) {
        this._mappingName = mappingName;
    }

    public Member getTarget() {
        return this._target;
    }

    public void setTarget(Member target) {
        this._target = target;
    }

    public void setTarget(Class clazz, String targetName, Class targetType) {
        String setter = "set" + targetName.substring(0, 1).toUpperCase() + targetName.substring(1);
        try {
            Log.debug((String)("Looking for method for setter: " + setter + " with arg " + targetType));
            this._target = IntrospectionUtil.findMethod((Class)clazz, (String)setter, (Class[])new Class[]{targetType}, (boolean)true, (boolean)false);
            this._className = clazz.getName();
        }
        catch (NoSuchMethodException me) {
            try {
                this._target = IntrospectionUtil.findField((Class)clazz, (String)targetName, (Class)targetType, (boolean)true, (boolean)false);
                this._className = clazz.getName();
            }
            catch (NoSuchFieldException fe) {
                throw new IllegalArgumentException("No such field or method " + targetName + " on class " + this._className);
            }
        }
    }

    public void inject(Object injectable) throws Exception {
        Member theTarget = this.getTarget();
        if (theTarget instanceof Field) {
            this.injectField((Field)theTarget, injectable);
        } else if (theTarget instanceof Method) {
            this.injectMethod((Method)theTarget, injectable);
        }
    }

    public Object lookupInjectedValue() throws Exception {
        InitialContext context = new InitialContext();
        return context.lookup("java:comp/env/" + this.getJndiName());
    }

    public void injectField(Field field, Object injectable) throws Exception {
        boolean accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(injectable, this.lookupInjectedValue());
        field.setAccessible(accessibility);
    }

    public void injectMethod(Method method, Object injectable) throws Exception {
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(injectable, this.lookupInjectedValue());
        method.setAccessible(accessibility);
    }

    private void validateInjection(Method method, Object injectable) throws NoSuchMethodException {
        if (injectable == null || method == null) {
            return;
        }
        injectable.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private void validateInjection(Field field, Object injectable) throws NoSuchFieldException {
        if (field == null || injectable == null) {
            return;
        }
        Field f = injectable.getClass().getField(field.getName());
        if (!f.getType().isAssignableFrom(field.getType())) {
            throw new NoSuchFieldException("Mismatching type of field: " + f.getType().getName() + " v " + field.getType().getName());
        }
    }
}

