/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public abstract class NamingEntry {
    public static final int SCOPE_GLOBAL = 0;
    public static final int SCOPE_LOCAL = 1;
    protected String jndiName;
    protected Object objectToBind;
    protected String absoluteObjectNameString;
    protected String namingEntryNameString;
    protected String objectNameString;
    protected Context context;
    protected boolean isGlobal;
    protected static ThreadLocal scope = new ThreadLocal();

    public static void setScope(int scopeType) {
        scope.set(new Integer(scopeType));
    }

    public static int getScope() {
        Integer val = (Integer)scope.get();
        return val == null ? 0 : val;
    }

    public static NamingEntry lookupNamingEntry(int scopeType, Class clazz, String jndiName) throws NamingException {
        NamingEntry namingEntry = null;
        switch (scopeType) {
            case 0: {
                try {
                    namingEntry = (NamingEntry)NamingEntry.lookupNamingEntry(new InitialContext(), clazz, jndiName);
                }
                catch (NameNotFoundException e) {
                    namingEntry = null;
                }
                break;
            }
            case 1: {
                if (NamingEntry.getScope() == 1) {
                    try {
                        InitialContext ic = new InitialContext();
                        namingEntry = (NamingEntry)NamingEntry.lookupNamingEntry((Context)ic.lookup("java:comp/env"), clazz, jndiName);
                    }
                    catch (NameNotFoundException e) {
                        namingEntry = null;
                    }
                    break;
                }
                Log.warn((String)"Can't lookup locally scoped naming entries outside of scope");
                throw new NamingException("Can't lookup locally scoped naming entries outside of scope");
            }
            default: {
                Log.info((String)("No scope to lookup name: " + jndiName));
            }
        }
        return namingEntry;
    }

    public static List lookupNamingEntries(int scopeType, Class clazz) throws NamingException {
        ArrayList list = new ArrayList();
        switch (scopeType) {
            case 0: {
                NamingEntry.lookupNamingEntries(list, new InitialContext(), clazz);
                break;
            }
            case 1: {
                if (NamingEntry.getScope() == 1) {
                    InitialContext ic = new InitialContext();
                    NamingEntry.lookupNamingEntries(list, (Context)ic.lookup("java:comp/env"), clazz);
                    break;
                }
                Log.warn((String)"Can't lookup local scope naming entries outside of local scope");
                throw new NamingException("Can't lookup locally scoped naming entries outside of scope");
            }
        }
        return list;
    }

    private static List lookupNamingEntries(List list, Context context, Class clazz) throws NamingException {
        try {
            String name = clazz == null ? "" : clazz.getName();
            NamingEnumeration<Binding> nenum = context.listBindings(name);
            while (nenum.hasMoreElements()) {
                Binding binding = nenum.next();
                if (binding.getObject() instanceof Context) {
                    NamingEntry.lookupNamingEntries(list, (Context)binding.getObject(), null);
                    continue;
                }
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException e) {
            Log.debug((String)("No entries of type " + clazz.getName() + " in context=" + context));
        }
        return list;
    }

    private static Object lookupNamingEntry(Context context, Class clazz, String jndiName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name name = parser.parse("");
        name.add(clazz.getName());
        name.addAll(parser.parse(jndiName));
        return context.lookup(name);
    }

    public NamingEntry(String jndiName, Object object) throws NamingException {
        this.jndiName = jndiName;
        this.objectToBind = object;
        InitialContext icontext = new InitialContext();
        switch (NamingEntry.getScope()) {
            case 0: {
                this.context = icontext;
                this.isGlobal = true;
                break;
            }
            case 1: {
                this.context = (Context)icontext.lookup("java:comp/env");
                this.isGlobal = false;
            }
        }
        NameParser parser = this.context.getNameParser("");
        Name contextName = parser.parse(this.context.getNameInNamespace());
        Name name = parser.parse("");
        name.add(this.getClass().getName());
        name.add(this.getJndiName());
        this.namingEntryNameString = name.toString();
        NamingUtil.bind((Context)this.context, (String)this.namingEntryNameString, (Object)this);
        String absoluteNamingEntryNameString = (this.isGlobal() ? "" : "java:") + name.addAll(0, contextName).toString();
        Name objectName = parser.parse(this.getJndiName());
        this.objectNameString = objectName.toString();
        NamingUtil.bind((Context)this.context, (String)this.objectNameString, (Object)this.getObjectToBind());
        Name fullName = objectName.addAll(0, contextName);
        this.absoluteObjectNameString = (this.isGlobal() ? "" : "java:") + fullName.toString();
        Log.debug((String)("Bound " + this.absoluteObjectNameString));
        Log.debug((String)("Bound " + absoluteNamingEntryNameString));
    }

    public void bindToEnv() throws NamingException {
        if (this.isGlobal()) {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            Log.info((String)("Binding java:comp/env/" + this.getJndiName() + " to " + this.absoluteObjectNameString));
            NamingUtil.bind((Context)env, (String)this.getJndiName(), (Object)new LinkRef(this.absoluteObjectNameString));
        }
    }

    public void unbindEnv() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            Log.info((String)("Unbinding java:comp/env/" + this.getJndiName()));
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public void unbind() {
        try {
            this.context.unbind(this.objectNameString);
            this.context.unbind(this.namingEntryNameString);
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Object getObjectToBind() throws NamingException {
        return this.objectToBind;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }
}

