/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.Resource;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.plus.webapp.AbstractConfiguration;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class Configuration
extends AbstractConfiguration {
    private Integer _key;

    public void bindEnvEntry(String name, Object value) throws Exception {
        EnvEntry envEntry = EnvEntry.getEnvEntry(1, name);
        if (envEntry != null && envEntry.isOverrideWebXml()) {
            return;
        }
        envEntry = EnvEntry.getEnvEntry(0, name);
        if (envEntry == null || !envEntry.isOverrideWebXml()) {
            InitialContext ic = new InitialContext();
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind((Context)envCtx, (String)name, (Object)value);
            Log.debug((String)("Bound java:comp/env/" + name + "=" + value));
        }
    }

    public void bindResourceRef(String name, Class typeClass) throws Exception {
        Resource resource = Resource.getResource(1, name);
        if (resource != null) {
            return;
        }
        resource = Resource.getResource(0, name);
        if (resource != null) {
            resource.bindToEnv();
            Log.debug((String)("Bound resourceref java:comp/env/" + name));
        } else {
            Log.warn((String)("No resource to bind matching name=" + name));
        }
    }

    public void bindResourceEnvRef(String name, Class typeClass) throws Exception {
        Resource resource = Resource.getResource(1, name);
        if (resource != null) {
            return;
        }
        resource = Resource.getResource(0, name);
        if (resource != null) {
            resource.bindToEnv();
            Log.debug((String)("Bound resource-env-ref java:comp/env/" + name));
        } else {
            Log.warn((String)("No resource to bind matching name=" + name));
        }
    }

    public void bindMessageDestinationRef(String name, Class typeClass) throws Exception {
        Resource resource = Resource.getResource(1, name);
        if (resource != null) {
            return;
        }
        resource = Resource.getResource(0, name);
        if (resource != null) {
            resource.bindToEnv();
            Log.debug((String)("Bound message-destination-ref java:comp/env/" + name));
        } else {
            Log.warn((String)("No resource to bind matching name=" + name));
        }
    }

    public void bindUserTransaction() throws Exception {
        Transaction transaction = Transaction.getTransaction(1);
        if (transaction != null) {
            transaction.bindToEnv();
            return;
        }
        transaction = Transaction.getTransaction(0);
        if (transaction != null) {
            transaction.bindToEnv();
            Log.debug((String)("Bound UserTransaction to java:comp/" + transaction.getJndiName()));
        }
    }

    public void configureClassLoader() throws Exception {
        super.configureClassLoader();
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.lockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.unlockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
        super.deconfigureWebApp();
    }

    protected void lockCompEnv() throws Exception {
        Random random = new Random();
        this._key = new Integer(random.nextInt());
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.lock", this._key);
    }

    protected void unlockCompEnv() throws Exception {
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.unlock", this._key);
    }
}

