/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import mousio.etcd4j.responses.EtcdResponseDecoder;
import mousio.etcd4j.responses.EtcdResponseDecoders;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EtcdException
extends Exception {
    private static final long serialVersionUID = -3921194095313052325L;
    public static final EtcdResponseDecoder<EtcdException> DECODER = EtcdResponseDecoders.json(EtcdException.class);
    public final String etcdCause;
    public final int errorCode;
    public final Long index;
    public final String etcdMessage;

    protected EtcdException(@JsonProperty(value="errorCode") Integer errorCode, @JsonProperty(value="cause") String cause, @JsonProperty(value="message") String message, @JsonProperty(value="index") Long index) {
        this.errorCode = errorCode;
        this.etcdCause = cause;
        this.etcdMessage = message;
        this.index = index;
    }

    @Override
    public String getMessage() {
        return String.format("[%s]: %s%s%s", this.errorCode, this.etcdMessage, this.etcdCause != null ? ", cause: " + this.etcdCause : "", this.index != null ? ", at index: " + this.index : "");
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getETCDCause() {
        return this.etcdCause;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isErrorCode(int code) {
        return this.errorCode == code;
    }

    public Long getIndex() {
        return this.index;
    }

    public String ETCDMessage() {
        return this.etcdMessage;
    }
}

