/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.AtomicBlock;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.closures.AtomicBooleanClosure;
import org.multiverse.api.closures.AtomicClosure;
import org.multiverse.api.closures.AtomicDoubleClosure;
import org.multiverse.api.closures.AtomicIntClosure;
import org.multiverse.api.closures.AtomicLongClosure;
import org.multiverse.api.closures.AtomicVoidClosure;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.api.references.BooleanRef;
import org.multiverse.api.references.DoubleRef;
import org.multiverse.api.references.IntRef;
import org.multiverse.api.references.LongRef;
import org.multiverse.api.references.Ref;
import org.multiverse.api.references.RefFactory;

public class StmUtils {
    private static final RefFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getDefaultRefFactory();
    private static final AtomicBlock defaultAtomicBlock = GlobalStmInstance.getGlobalStmInstance().getDefaultAtomicBlock();

    public static <E> E execute(AtomicClosure<E> closure) {
        return defaultAtomicBlock.execute(closure);
    }

    public static <E> E executeChecked(AtomicClosure<E> closure) throws Exception {
        return defaultAtomicBlock.executeChecked(closure);
    }

    public static int execute(AtomicIntClosure closure) {
        return defaultAtomicBlock.execute(closure);
    }

    public static int executeChecked(AtomicIntClosure closure) throws Exception {
        return defaultAtomicBlock.executeChecked(closure);
    }

    public static long execute(AtomicLongClosure closure) {
        return defaultAtomicBlock.execute(closure);
    }

    public static long executeChecked(AtomicLongClosure closure) throws Exception {
        return defaultAtomicBlock.executeChecked(closure);
    }

    public static double execute(AtomicDoubleClosure closure) {
        return defaultAtomicBlock.execute(closure);
    }

    public static double executeChecked(AtomicDoubleClosure closure) throws Exception {
        return defaultAtomicBlock.executeChecked(closure);
    }

    public static boolean execute(AtomicBooleanClosure closure) {
        return defaultAtomicBlock.execute(closure);
    }

    public static boolean executeChecked(AtomicBooleanClosure closure) throws Exception {
        return defaultAtomicBlock.executeChecked(closure);
    }

    public static void execute(AtomicVoidClosure closure) {
        defaultAtomicBlock.execute(closure);
    }

    public static void executeChecked(AtomicVoidClosure closure) throws Exception {
        defaultAtomicBlock.executeChecked(closure);
    }

    public static IntRef newIntRef(int value) {
        return refFactory.newIntRef(value);
    }

    public static IntRef newIntRef() {
        return refFactory.newIntRef(0);
    }

    public static LongRef newLongRef() {
        return refFactory.newLongRef(0L);
    }

    public static LongRef newLongRef(long value) {
        return refFactory.newLongRef(value);
    }

    public static DoubleRef newDoubleRef() {
        return refFactory.newDoubleRef(0.0);
    }

    public static DoubleRef newDoubleRef(double value) {
        return refFactory.newDoubleRef(value);
    }

    public static BooleanRef newBooleanRef() {
        return refFactory.newBooleanRef(false);
    }

    public static BooleanRef newBooleanRef(boolean value) {
        return refFactory.newBooleanRef(value);
    }

    public static <E> Ref<E> newRef() {
        return refFactory.newRef(null);
    }

    public static <E> Ref<E> newRef(E value) {
        return refFactory.newRef(value);
    }

    public static void retry() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.retry();
    }

    public static void prepare() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.prepare();
    }

    public static void abort() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.abort();
    }

    public static void ensureWrites() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.ensureWrites();
    }

    public static void commit() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.commit();
    }

    public static void scheduleCompensatingOrDeferredTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.register(new TransactionLifecycleListener(){

            @Override
            public void notify(Transaction tx, TransactionLifecycleEvent event) {
                if (event == TransactionLifecycleEvent.PostCommit || event == TransactionLifecycleEvent.PostAbort) {
                    task.run();
                }
            }
        });
    }

    public static void scheduleDeferredTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.register(new TransactionLifecycleListener(){

            @Override
            public void notify(Transaction tx, TransactionLifecycleEvent event) {
                if (event == TransactionLifecycleEvent.PostCommit) {
                    task.run();
                }
            }
        });
    }

    public static void scheduleCompensatingTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.register(new TransactionLifecycleListener(){

            @Override
            public void notify(Transaction tx, TransactionLifecycleEvent event) {
                if (event == TransactionLifecycleEvent.PostAbort) {
                    task.run();
                }
            }
        });
    }

    private StmUtils() {
    }
}

