/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.conflictcounters;

import org.multiverse.api.exceptions.TodoException;
import org.multiverse.stms.beta.conflictcounters.GlobalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;

public final class LocalConflictCounter {
    private final GlobalConflictCounter globalConflictCounter;
    private final long[] array;
    private long localConflictCount;

    public LocalConflictCounter(GlobalConflictCounter globalConflictCounter) {
        if (globalConflictCounter == null) {
            throw new NullPointerException();
        }
        this.globalConflictCounter = globalConflictCounter;
        this.array = new long[globalConflictCounter.getLength()];
        this.reset();
    }

    public GlobalConflictCounter getGlobalConflictCounter() {
        return this.globalConflictCounter;
    }

    public boolean syncAndCheckConflict() {
        if (this.array.length == 1) {
            long globalConflictCount = this.globalConflictCounter.getConflictCount(0);
            if (globalConflictCount != this.localConflictCount) {
                this.localConflictCount = globalConflictCount;
                return true;
            }
            return false;
        }
        boolean conflict = false;
        for (int k = 0; k < this.array.length; ++k) {
            long local = this.array[k];
            if (local < 0L) continue;
            long global = this.globalConflictCounter.getConflictCount(k);
            if (global != local) {
                conflict = true;
            }
            this.array[k] = global;
        }
        return conflict;
    }

    public long get() {
        if (this.array.length == 1) {
            return this.localConflictCount;
        }
        long result = 0L;
        for (int k = 0; k < this.array.length; ++k) {
            result += this.array[k];
        }
        return result;
    }

    public void arrive(BetaTransactionalObject ref) {
        throw new TodoException();
    }

    public void reset() {
        if (this.array.length == 1) {
            this.localConflictCount = this.globalConflictCounter.getConflictCount(0);
            return;
        }
        System.out.println("long conflict counter reset");
        System.arraycopy(this.globalConflictCounter.getInitArray(), 0, this.array, 0, this.array.length);
    }
}

