/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactionalobjects;

import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.functions.Function;
import org.multiverse.stms.beta.BetaObjectPool;
import org.multiverse.stms.beta.BetaStmConstants;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactionalobjects.CallableNode;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public abstract class BetaTranlocal
implements BetaStmConstants {
    public long version;
    public BetaTransaction tx;
    public BetaTransactionalObject owner;
    public CallableNode headCallable;
    public int status = 0;
    private int lockMode;
    private boolean checkConflict;
    private boolean hasDepartObligation;
    private boolean isDirty;
    private boolean ignore;

    public BetaTranlocal(BetaTransactionalObject owner) {
        this.owner = owner;
    }

    public final boolean isNew() {
        return this.status == 0;
    }

    public final boolean isConstructing() {
        return this.status == 1;
    }

    public final void setStatus(int state) {
        this.status = state;
    }

    public final boolean isReadonly() {
        return this.status == 4;
    }

    public final boolean isNew(int status) {
        return status == 0;
    }

    public final boolean isConstructing(int status) {
        return status == 1;
    }

    public final boolean isReadonly(int status) {
        return status == 4;
    }

    public final boolean isConflictCheckNeeded() {
        return this.checkConflict;
    }

    public final void setIsConflictCheckNeeded(boolean value) {
        this.checkConflict = value;
    }

    public final int getLockMode() {
        return this.lockMode;
    }

    public final void setLockMode(int lockMode) {
        this.lockMode = lockMode;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean value) {
        this.isDirty = value;
    }

    public final boolean isCommuting() {
        return this.status == 3;
    }

    public final boolean hasDepartObligation() {
        return this.hasDepartObligation;
    }

    public final void setDepartObligation(boolean value) {
        this.hasDepartObligation = value;
    }

    public abstract void prepareForPooling(BetaObjectPool var1);

    public boolean ignore() {
        return this.ignore;
    }

    public void setIgnore(boolean value) {
        this.ignore = value;
    }

    public final void openForCommute() {
        if (this.tx.status != 1) {
            throw this.tx.abortCommute(this.owner, null);
        }
    }

    public final void openForConstruction() {
        if (this.tx.status != 1) {
            throw this.tx.abortOpenForConstruction(this.owner);
        }
        switch (this.status) {
            case 0: {
                if (this.tx.config.readonly) {
                    throw this.tx.abortOpenForWriteWhenReadonly(this.owner);
                }
                this.status = 1;
                return;
            }
            case 1: {
                return;
            }
            case 3: {
                throw new IllegalStateException();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 4: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public abstract void openForRead(int var1);

    public abstract void openForWrite(int var1);

    public final void upgradeLockMode(int desiredLockMode) {
        if (this.tx.status != 1) {
            throw this.tx.abortOpenForWrite(this.owner);
        }
        if (this.lockMode >= desiredLockMode) {
            return;
        }
        if (!this.isCommuting()) {
            // empty if block
        }
        BetaTransactionConfiguration config = this.tx.config;
        boolean lockSuccess = this.owner.___tryLockAndCheckConflict(this.tx, config.spinCount, this, desiredLockMode == 2);
        if (!lockSuccess) {
            throw ReadWriteConflict.INSTANCE;
        }
    }

    public final void checkConflict() {
        if (this.tx.status != 1) {
            throw this.tx.abortOpenForWrite(this.owner);
        }
        if (this.lockMode != 0) {
            return;
        }
        if (this.checkConflict) {
            return;
        }
        this.checkConflict = true;
    }

    public abstract boolean calculateIsDirty();

    public abstract void evaluateCommutingFunctions(BetaObjectPool var1);

    public abstract void addCommutingFunction(Function var1, BetaObjectPool var2);

    public final boolean prepareDirtyUpdates(BetaObjectPool pool, BetaTransaction tx, int spinCount) {
        switch (this.status) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return true;
            }
            case 3: {
                if (!this.owner.___load(spinCount, tx, 2, this)) {
                    return false;
                }
                this.evaluateCommutingFunctions(pool);
                return true;
            }
            case 4: {
                if (!this.checkConflict) {
                    return true;
                }
                if (this.lockMode != 0) {
                    return true;
                }
                return this.owner.___tryLockAndCheckConflict(tx, spinCount, this, false);
            }
            case 2: {
                if (!this.isDirty && !this.calculateIsDirty()) {
                    if (!this.checkConflict) {
                        return true;
                    }
                    if (this.lockMode != 0) {
                        return true;
                    }
                    return this.owner.___tryLockAndCheckConflict(tx, spinCount, this, false);
                }
                if (this.lockMode == 2) {
                    return true;
                }
                return this.owner.___tryLockAndCheckConflict(tx, spinCount, this, true);
            }
        }
        throw new IllegalStateException();
    }

    public final boolean prepareAllUpdates(BetaObjectPool pool, BetaTransaction tx, int spinCount) {
        switch (this.status) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return true;
            }
            case 3: {
                if (!this.owner.___load(spinCount, tx, 2, this)) {
                    return false;
                }
                this.evaluateCommutingFunctions(pool);
                return true;
            }
            case 4: {
                if (!this.checkConflict) {
                    return true;
                }
                if (this.lockMode != 0) {
                    return true;
                }
                return this.owner.___tryLockAndCheckConflict(tx, spinCount, this, false);
            }
            case 2: {
                if (this.lockMode == 2) {
                    return true;
                }
                return this.owner.___tryLockAndCheckConflict(tx, spinCount, this, true);
            }
        }
        throw new IllegalStateException();
    }
}

