/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactionalobjects;

import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.blocking.RetryLatch;
import org.multiverse.api.exceptions.TransactionRequiredException;
import org.multiverse.stms.beta.BetaObjectPool;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.orec.FastOrec;
import org.multiverse.stms.beta.orec.Orec;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.BetaTransaction;

public abstract class VeryAbstractBetaTransactionalObject
extends FastOrec
implements BetaTransactionalObject {
    protected static final long listenersOffset;
    protected BetaTransaction ___lockOwner;
    protected volatile Listeners ___listeners;
    protected volatile long ___version;
    protected int ___identityHashCode;
    public final BetaStm ___stm;

    public VeryAbstractBetaTransactionalObject(BetaStm stm) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.___stm = stm;
    }

    @Override
    public final long getVersion() {
        return this.___version;
    }

    @Override
    public final BetaStm getStm() {
        return this.___stm;
    }

    @Override
    public final BetaTransaction ___getLockOwner() {
        return this.___lockOwner;
    }

    @Override
    public final Orec ___getOrec() {
        return this;
    }

    protected final Listeners ___removeListenersAfterWrite() {
        Listeners removedListeners;
        if (this.___listeners == null) {
            return null;
        }
        while (!___unsafe.compareAndSwapObject(this, listenersOffset, removedListeners = this.___listeners, null)) {
        }
        return removedListeners;
    }

    @Override
    public final int ___registerChangeListener(RetryLatch latch, BetaTranlocal tranlocal, BetaObjectPool pool, long listenerEra) {
        boolean removed;
        Listeners current;
        boolean registered;
        if (tranlocal.isCommuting() || tranlocal.isConstructing()) {
            return 2;
        }
        long version = tranlocal.version;
        if (version != this.___version) {
            latch.open(listenerEra);
            return 1;
        }
        Listeners update = pool.takeListeners();
        update.threadName = Thread.currentThread().getName();
        update.listener = latch;
        update.listenerEra = listenerEra;
        do {
            if (version != this.___version) {
                latch.open(listenerEra);
                return 1;
            }
            update.next = current = this.___listeners;
        } while (!(registered = ___unsafe.compareAndSwapObject(this, listenersOffset, current, update)));
        if (version == this.___version) {
            return 0;
        }
        while (!(removed = ___unsafe.compareAndSwapObject(this, listenersOffset, update = this.___listeners, null))) {
        }
        if (update != null) {
            update.openAll(pool);
        }
        return 1;
    }

    @Override
    public final boolean ___tryLockAndCheckConflict(BetaTransaction newLockOwner, int spinCount, BetaTranlocal tranlocal, boolean commitLock) {
        int currentLockMode = tranlocal.getLockMode();
        if (currentLockMode != 0) {
            if (commitLock && currentLockMode == 1) {
                tranlocal.setLockMode(2);
                this.___upgradeToCommitLock();
            }
            return true;
        }
        long expectedVersion = tranlocal.version;
        if (this.___version != expectedVersion) {
            return false;
        }
        if (!tranlocal.hasDepartObligation()) {
            int arriveStatus = this.___tryLockAndArrive(spinCount, commitLock);
            if (arriveStatus == 2) {
                return false;
            }
            if (arriveStatus == 0) {
                tranlocal.setDepartObligation(true);
            }
        } else if (!this.___tryLockAfterNormalArrive(spinCount, commitLock)) {
            return false;
        }
        this.___lockOwner = newLockOwner;
        tranlocal.setLockMode(commitLock ? 2 : 1);
        return expectedVersion == this.___version;
    }

    @Override
    public final boolean ___hasReadConflict(BetaTranlocal tranlocal) {
        if (tranlocal.getLockMode() != 0) {
            return false;
        }
        if (this.___hasCommitLock()) {
            return true;
        }
        return tranlocal.version != this.___version;
    }

    @Override
    public final boolean atomicIsFree() {
        return !this.___hasLock();
    }

    @Override
    public final boolean atomicIsPrivatized() {
        return this.___hasCommitLock();
    }

    @Override
    public final boolean isPrivatizedBySelf() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("No transaction is found for the isPrivatizedBySelf operation");
        }
        return this.isPrivatizedBySelf((BetaTransaction)tx);
    }

    @Override
    public final boolean isPrivatizedBySelf(Transaction tx) {
        return this.isPrivatizedBySelf((BetaTransaction)tx);
    }

    public final boolean isPrivatizedBySelf(BetaTransaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        BetaTranlocal tranlocal = tx.locate(this);
        return tranlocal != null && tranlocal.getLockMode() == 2;
    }

    @Override
    public final boolean isPrivatizedByOther() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("No transaction is found for the isPrivatizedByOther operation");
        }
        return this.isPrivatizedByOther((BetaTransaction)tx);
    }

    @Override
    public final boolean isPrivatizedByOther(Transaction tx) {
        return this.isPrivatizedByOther((BetaTransaction)tx);
    }

    public final boolean isPrivatizedByOther(BetaTransaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        BetaTranlocal tranlocal = tx.locate(this);
        if (!this.___hasCommitLock()) {
            return false;
        }
        return tranlocal == null || tranlocal.getLockMode() == 0;
    }

    @Override
    public final boolean atomicIsEnsured() {
        return this.___hasUpdateLock();
    }

    @Override
    public final boolean isEnsuredBySelf() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("No transaction is found for the isEnsuredBySelf operation");
        }
        return this.isEnsuredBySelf((BetaTransaction)tx);
    }

    @Override
    public final boolean isEnsuredBySelf(Transaction tx) {
        return this.isEnsuredBySelf((BetaTransaction)tx);
    }

    public final boolean isEnsuredBySelf(BetaTransaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        BetaTranlocal tranlocal = tx.locate(this);
        return tranlocal != null && tranlocal.getLockMode() == 1;
    }

    @Override
    public final boolean isEnsuredByOther() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("No transaction is found for the isEnsuredByOther operation");
        }
        return this.isEnsuredByOther((BetaTransaction)tx);
    }

    @Override
    public final boolean isEnsuredByOther(Transaction tx) {
        return this.isEnsuredByOther((BetaTransaction)tx);
    }

    public final boolean isEnsuredByOther(BetaTransaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        BetaTranlocal tranlocal = tx.locate(this);
        if (!this.___hasUpdateLock()) {
            return false;
        }
        return tranlocal == null || tranlocal.getLockMode() == 0;
    }

    protected final int ___arriveAndLockOrBackoff() {
        for (int k = 0; k <= this.___stm.defaultMaxRetries; ++k) {
            int arriveStatus = this.___tryLockAndArrive(this.___stm.spinCount, true);
            if (arriveStatus != 2) {
                return arriveStatus;
            }
            this.___stm.defaultBackoffPolicy.delayedUninterruptible(k + 1);
        }
        return 2;
    }

    @Override
    public final int ___identityHashCode() {
        int tmp = this.___identityHashCode;
        if (tmp != 0) {
            return tmp;
        }
        this.___identityHashCode = tmp = System.identityHashCode(this);
        return tmp;
    }

    static {
        try {
            listenersOffset = ___unsafe.objectFieldOffset(VeryAbstractBetaTransactionalObject.class.getDeclaredField("___listeners"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

