/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import java.util.ArrayList;
import java.util.List;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public abstract class AbstractFatBetaTransaction
extends BetaTransaction {
    protected ArrayList<TransactionLifecycleListener> normalListeners;

    public AbstractFatBetaTransaction(int poolTransactionType, BetaTransactionConfiguration config) {
        super(poolTransactionType, config);
    }

    protected final void notifyListeners(List<TransactionLifecycleListener> listeners, TransactionLifecycleEvent event) {
        if (listeners == null) {
            return;
        }
        int size = listeners.size();
        for (int k = 0; k < size; ++k) {
            listeners.get(k).notify(this, event);
        }
    }

    @Override
    public final ArrayList<TransactionLifecycleListener> getNormalListeners() {
        return this.normalListeners;
    }

    @Override
    public final void copyForSpeculativeFailure(BetaTransaction tx) {
        this.remainingTimeoutNs = tx.getRemainingTimeoutNs();
        this.attempt = tx.getAttempt();
    }

    @Override
    public final void register(TransactionLifecycleListener listener) {
        if (listener == null) {
            this.abort();
            throw new NullPointerException();
        }
        switch (this.status) {
            case 0: 
            case 1: 
            case 2: {
                if (this.normalListeners == null) {
                    this.normalListeners = this.pool.takeArrayList();
                }
                this.normalListeners.add(listener);
                break;
            }
            case 4: {
                throw new DeadTransactionException();
            }
            case 3: {
                throw new DeadTransactionException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

