/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.PessimisticLockLevel;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.TransactionConfiguration;
import org.multiverse.api.exceptions.IllegalTransactionFactoryException;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.sensors.TransactionSensor;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.BetaStmConfiguration;
import org.multiverse.stms.beta.BetaStmConstants;
import org.multiverse.stms.beta.conflictcounters.GlobalConflictCounter;
import org.multiverse.stms.beta.transactions.SpeculativeBetaConfiguration;

public final class BetaTransactionConfiguration
implements TransactionConfiguration,
BetaStmConstants {
    public static final AtomicLong idGenerator = new AtomicLong();
    public final BetaStm stm;
    public final GlobalConflictCounter globalConflictCounter;
    public final AtomicReference<SpeculativeBetaConfiguration> speculativeConfiguration = new AtomicReference();
    public final TransactionSensor transactionSensor;
    public PropagationLevel propagationLevel;
    public IsolationLevel isolationLevel;
    public boolean writeSkewAllowed;
    public boolean inconsistentReadAllowed;
    public PessimisticLockLevel pessimisticLockLevel;
    public int readLockMode;
    public int writeLockMode;
    public final String familyName;
    public final boolean isAnonymous;
    public boolean interruptible = false;
    public boolean durable = false;
    public boolean readonly = false;
    public int spinCount = 16;
    public boolean dirtyCheck = true;
    public int minimalArrayTreeSize = 4;
    public boolean trackReads = true;
    public boolean blockingAllowed = true;
    public int maxRetries;
    public boolean speculativeConfigEnabled = true;
    public int maxArrayTransactionSize;
    public BackoffPolicy backoffPolicy;
    public long timeoutNs = Long.MAX_VALUE;
    public TraceLevel traceLevel = TraceLevel.None;
    public ArrayList<TransactionLifecycleListener> permanentListeners;

    public BetaTransactionConfiguration(BetaStm stm) {
        this(stm, new BetaStmConfiguration());
    }

    public BetaTransactionConfiguration(BetaStm stm, String familyName, boolean isAnonymous) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        this.familyName = familyName;
        this.isAnonymous = isAnonymous;
        this.globalConflictCounter = stm.getGlobalConflictCounter();
        this.transactionSensor = isAnonymous ? null : stm.getProfiler().getTransactionSensor(this);
    }

    public BetaTransactionConfiguration(BetaStm stm, BetaStmConfiguration configuration) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        this.interruptible = configuration.interruptible;
        this.readonly = configuration.readonly;
        this.spinCount = configuration.spinCount;
        this.pessimisticLockLevel = configuration.pessimisticLockLevel;
        this.dirtyCheck = configuration.dirtyCheck;
        this.minimalArrayTreeSize = configuration.minimalArrayTreeSize;
        this.trackReads = configuration.trackReads;
        this.blockingAllowed = configuration.blockingAllowed;
        this.maxRetries = configuration.maxRetries;
        this.speculativeConfigEnabled = configuration.speculativeConfigEnabled;
        this.maxArrayTransactionSize = configuration.maxArrayTransactionSize;
        this.backoffPolicy = configuration.backoffPolicy;
        this.timeoutNs = configuration.timeoutNs;
        this.traceLevel = configuration.traceLevel;
        this.isolationLevel = configuration.isolationLevel;
        this.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        this.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        this.propagationLevel = configuration.propagationLevel;
        this.familyName = "anonymoustransaction-" + idGenerator.incrementAndGet();
        this.isAnonymous = true;
        this.globalConflictCounter = stm.getGlobalConflictCounter();
        this.transactionSensor = null;
    }

    public BetaTransactionConfiguration(BetaStm stm, int maxArrayTransactionSize) {
        this(stm);
        this.maxArrayTransactionSize = maxArrayTransactionSize;
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean hasTimeout() {
        return this.timeoutNs != Long.MAX_VALUE;
    }

    public SpeculativeBetaConfiguration getSpeculativeConfiguration() {
        return this.speculativeConfiguration.get();
    }

    @Override
    public long getTimeoutNs() {
        return this.timeoutNs;
    }

    @Override
    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public boolean isInterruptible() {
        return this.interruptible;
    }

    @Override
    public BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public int getMaxArrayTransactionSize() {
        return this.maxArrayTransactionSize;
    }

    @Override
    public boolean isSpeculativeConfigEnabled() {
        return this.speculativeConfigEnabled;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public int getSpinCount() {
        return this.spinCount;
    }

    @Override
    public PessimisticLockLevel getPessimisticLockLevel() {
        return this.pessimisticLockLevel;
    }

    @Override
    public boolean isDirtyCheck() {
        return this.dirtyCheck;
    }

    @Override
    public BetaStm getStm() {
        return this.stm;
    }

    public GlobalConflictCounter getGlobalConflictCounter() {
        return this.globalConflictCounter;
    }

    @Override
    public boolean isReadTrackingEnabled() {
        return this.trackReads;
    }

    @Override
    public boolean isBlockingAllowed() {
        return this.blockingAllowed;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public PropagationLevel getPropagationLevel() {
        return this.propagationLevel;
    }

    @Override
    public List<TransactionLifecycleListener> getPermanentListeners() {
        if (this.permanentListeners == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.permanentListeners);
    }

    public void needsOrelse() {
        SpeculativeBetaConfiguration update;
        SpeculativeBetaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.createWithOrElseRequired())) {
        }
    }

    public void needsListeners() {
        SpeculativeBetaConfiguration update;
        SpeculativeBetaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.createWithListenersRequired())) {
        }
    }

    public void needsCommute() {
        SpeculativeBetaConfiguration update;
        SpeculativeBetaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.createWithCommuteRequired())) {
        }
    }

    public void needsMinimalTransactionLength(int newLength) {
        SpeculativeBetaConfiguration next;
        SpeculativeBetaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), next = current.createWithMinimalLength(newLength))) {
        }
    }

    public BetaTransactionConfiguration init() {
        if (!(this.writeSkewAllowed || this.trackReads || this.readonly)) {
            String msg = String.format("'[%s] If no writeskew is allowed, read tracking should be enabled", this.familyName);
            throw new IllegalTransactionFactoryException(msg);
        }
        if (this.blockingAllowed && !this.trackReads) {
            String msg = String.format("[%s] If blocking is allowed, read tracking should be enabled", this.familyName);
            throw new IllegalTransactionFactoryException(msg);
        }
        if (this.pessimisticLockLevel == PessimisticLockLevel.PrivatizeReads && !this.trackReads) {
            String msg = String.format("[%s] If all reads should be locked, read tracking should be enabled", this.familyName);
            throw new IllegalTransactionFactoryException(msg);
        }
        if (this.speculativeConfigEnabled) {
            boolean isFat;
            boolean bl = isFat = !this.writeSkewAllowed;
            if (this.speculativeConfiguration.get() == null) {
                SpeculativeBetaConfiguration newSpeculativeConfiguration = new SpeculativeBetaConfiguration(isFat);
                this.speculativeConfiguration.compareAndSet(null, newSpeculativeConfiguration);
            }
        }
        return this;
    }

    public BetaTransactionConfiguration setTimeoutNs(long timeoutNs) {
        if (timeoutNs < 0L) {
            throw new IllegalArgumentException("timeoutNs can't be smaller than 0");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setFamilyName(String familyName) {
        if (familyName == null) {
            throw new NullPointerException("familyName can't be null");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, familyName, false);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries can't be smaller than 0");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setReadTrackingEnabled(boolean trackReads) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setSpeculativeConfigurationEnabled(boolean speculativeConfigEnabled) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setReadonly(boolean readonly) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setDirtyCheckEnabled(boolean dirtyCheck) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setBlockingAllowed(boolean blockingEnabled) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = blockingEnabled;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setInterruptible(boolean interruptible) {
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setSpinCount(int spinCount) {
        if (spinCount < 0) {
            throw new IllegalArgumentException("spinCount can't be smaller than 0");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setPessimisticLockLevel(PessimisticLockLevel pessimisticLockLevel) {
        if (pessimisticLockLevel == null) {
            throw new NullPointerException("pessimisticLockLevel can't be null");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = pessimisticLockLevel;
        config.readLockMode = pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setBackoffPolicy(BackoffPolicy backoffPolicy) {
        if (backoffPolicy == null) {
            throw new NullPointerException("backoffPolicy can't be null");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setTraceLevel(TraceLevel traceLevel) {
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel can't be null");
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setPropagationLevel(PropagationLevel propagationLevel) {
        if (propagationLevel == null) {
            throw new NullPointerException();
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = propagationLevel;
        config.permanentListeners = this.permanentListeners;
        return config;
    }

    public BetaTransactionConfiguration setIsolationLevel(IsolationLevel isolationLevel) {
        if (isolationLevel == null) {
            throw new NullPointerException();
        }
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = this.permanentListeners;
        config.isolationLevel = isolationLevel;
        config.writeSkewAllowed = isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = isolationLevel.isInconsistentReadAllowed();
        return config;
    }

    public BetaTransactionConfiguration addPermanentListener(TransactionLifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<TransactionLifecycleListener> newPermanentListeners = new ArrayList<TransactionLifecycleListener>();
        if (this.permanentListeners != null) {
            newPermanentListeners.addAll(this.permanentListeners);
        }
        newPermanentListeners.add(listener);
        BetaTransactionConfiguration config = new BetaTransactionConfiguration(this.stm, this.familyName, this.isAnonymous);
        config.readonly = this.readonly;
        config.spinCount = this.spinCount;
        config.pessimisticLockLevel = this.pessimisticLockLevel;
        config.readLockMode = this.pessimisticLockLevel.getReadLockMode();
        config.writeLockMode = this.pessimisticLockLevel.getWriteLockMode();
        config.dirtyCheck = this.dirtyCheck;
        config.trackReads = this.trackReads;
        config.maxRetries = this.maxRetries;
        config.blockingAllowed = this.blockingAllowed;
        config.durable = this.durable;
        config.speculativeConfigEnabled = this.speculativeConfigEnabled;
        config.maxArrayTransactionSize = this.maxArrayTransactionSize;
        config.backoffPolicy = this.backoffPolicy;
        config.interruptible = this.interruptible;
        config.timeoutNs = this.timeoutNs;
        config.traceLevel = this.traceLevel;
        config.isolationLevel = this.isolationLevel;
        config.writeSkewAllowed = this.isolationLevel.isWriteSkewAllowed();
        config.inconsistentReadAllowed = this.isolationLevel.isInconsistentReadAllowed();
        config.propagationLevel = this.propagationLevel;
        config.permanentListeners = newPermanentListeners;
        return config;
    }

    public String toString() {
        return "BetaTransactionConfiguration{familyName='" + this.familyName + ", propagationLevel=" + (Object)((Object)this.propagationLevel) + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + ", pessimisticLockLevel=" + this.pessimisticLockLevel + ", traceLevel=" + (Object)((Object)this.traceLevel) + ", readonly=" + this.readonly + ", speculativeConfiguration=" + this.speculativeConfiguration + ", spinCount=" + this.spinCount + ", dirtyCheck=" + this.dirtyCheck + ", minimalArrayTreeSize=" + this.minimalArrayTreeSize + ", trackReads=" + this.trackReads + ", maxRetries=" + this.maxRetries + ", speculativeConfigEnabled=" + this.speculativeConfigEnabled + ", maxArrayTransactionSize=" + this.maxArrayTransactionSize + ", isAnonymous=" + this.isAnonymous + ", backoffPolicy=" + this.backoffPolicy + ", blockingAllowed=" + this.blockingAllowed + ", timeoutNs=" + this.timeoutNs + ", interruptible=" + this.interruptible + ", permanentListeners=" + this.permanentListeners + '}';
    }
}

