/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import org.multiverse.api.IsolationLevel;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.AbstractFatBetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public final class FatArrayTreeBetaTransaction
extends AbstractFatBetaTransaction {
    private BetaTranlocal[] array;
    private LocalConflictCounter localConflictCounter;
    private int size;
    private boolean hasReads;
    private boolean hasUntrackedReads;
    private boolean evaluatingCommute;

    public FatArrayTreeBetaTransaction(BetaStm stm) {
        this(new BetaTransactionConfiguration(stm).init());
    }

    public FatArrayTreeBetaTransaction(BetaTransactionConfiguration config) {
        super(5, config);
        this.localConflictCounter = config.globalConflictCounter.createLocalConflictCounter();
        this.array = new BetaTranlocal[config.minimalArrayTreeSize];
        this.remainingTimeoutNs = config.timeoutNs;
    }

    @Override
    public final LocalConflictCounter getLocalConflictCounter() {
        return this.localConflictCounter;
    }

    public int size() {
        return this.size;
    }

    public float getUsage() {
        return (float)this.size * 1.0f / (float)this.array.length;
    }

    @Override
    public final boolean tryLock(BetaTransactionalObject ref, int lockMode) {
        throw new TodoException();
    }

    @Override
    public void ensureWrites() {
        if (this.status != 1) {
            throw this.abortEnsureWrites();
        }
        if (this.config.writeLockMode != 0) {
            return;
        }
        if (this.size == 0) {
            return;
        }
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.array.length; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null || tranlocal.isReadonly() || tranlocal.owner.___tryLockAndCheckConflict(this, spinCount, tranlocal, false)) continue;
            throw this.abortOnReadConflict();
        }
    }

    @Override
    public final <E> E read(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> void flattenCommute(BetaRef<E> ref, BetaRefTranlocal<E> tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final <E> BetaRefTranlocal<E> open(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return (BetaRefTranlocal)this.array[index];
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public <E> BetaRefTranlocal<E> openForRead(BetaRef<E> ref, int lockMode) {
        BetaRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaRefTranlocal tranlocal2 = (BetaRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public <E> BetaRefTranlocal<E> openForWrite(BetaRef<E> ref, int lockMode) {
        BetaRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaRefTranlocal tranlocal2 = (BetaRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForConstruction(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public <E> void commute(BetaRef<E> ref, Function<E> function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final int read(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaIntRef ref, BetaIntRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaIntRefTranlocal open(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return (BetaIntRefTranlocal)this.array[index];
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public BetaIntRefTranlocal openForRead(BetaIntRef ref, int lockMode) {
        BetaIntRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaIntRefTranlocal tranlocal2 = (BetaIntRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaIntRefTranlocal openForWrite(BetaIntRef ref, int lockMode) {
        BetaIntRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaIntRefTranlocal tranlocal2 = (BetaIntRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForConstruction(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public void commute(BetaIntRef ref, IntFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaIntRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final boolean read(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaBooleanRef ref, BetaBooleanRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaBooleanRefTranlocal open(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return (BetaBooleanRefTranlocal)this.array[index];
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public BetaBooleanRefTranlocal openForRead(BetaBooleanRef ref, int lockMode) {
        BetaBooleanRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaBooleanRefTranlocal tranlocal2 = (BetaBooleanRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaBooleanRefTranlocal openForWrite(BetaBooleanRef ref, int lockMode) {
        BetaBooleanRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaBooleanRefTranlocal tranlocal2 = (BetaBooleanRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForConstruction(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public void commute(BetaBooleanRef ref, BooleanFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final double read(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaDoubleRef ref, BetaDoubleRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaDoubleRefTranlocal open(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return (BetaDoubleRefTranlocal)this.array[index];
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public BetaDoubleRefTranlocal openForRead(BetaDoubleRef ref, int lockMode) {
        BetaDoubleRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaDoubleRefTranlocal tranlocal2 = (BetaDoubleRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaDoubleRefTranlocal openForWrite(BetaDoubleRef ref, int lockMode) {
        BetaDoubleRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaDoubleRefTranlocal tranlocal2 = (BetaDoubleRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForConstruction(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public void commute(BetaDoubleRef ref, DoubleFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final long read(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.array[index];
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaLongRef ref, BetaLongRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaLongRefTranlocal open(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return (BetaLongRefTranlocal)this.array[index];
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public BetaLongRefTranlocal openForRead(BetaLongRef ref, int lockMode) {
        BetaLongRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaLongRefTranlocal tranlocal2 = (BetaLongRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaLongRefTranlocal openForWrite(BetaLongRef ref, int lockMode) {
        BetaLongRefTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaLongRefTranlocal tranlocal2 = (BetaLongRefTranlocal)this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForConstruction(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public void commute(BetaLongRef ref, LongFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaLongRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaTransactionalObject ref, BetaTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaTranlocal open(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.getStm() != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index != -1) {
            return this.array[index];
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public BetaTranlocal openForRead(BetaTransactionalObject ref, int lockMode) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaTranlocal tranlocal2 = this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        if (this.hasReadConflict()) {
            ref.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
        } else {
            this.hasUntrackedReads = true;
        }
        return tranlocal;
    }

    @Override
    public BetaTranlocal openForWrite(BetaTransactionalObject ref, int lockMode) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (index > -1) {
            BetaTranlocal tranlocal2 = this.array[index];
            if (tranlocal2.isCommuting()) {
                this.flattenCommute(ref, tranlocal2, lockMode);
            } else if (tranlocal2.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal2, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            if (tranlocal2.isReadonly()) {
                tranlocal2.setStatus(2);
                this.hasUpdates = true;
            }
            return tranlocal2;
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
            this.pool.put(tranlocal);
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        tranlocal.tx = this;
        tranlocal.setStatus(2);
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.hasUpdates = true;
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForConstruction(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index > -1) {
            BetaTranlocal tranlocal = this.array[index];
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        tranlocal.setDirty(true);
        this.attach(ref, tranlocal, identityHashCode);
        ++this.size;
        return tranlocal;
    }

    @Override
    public void commute(BetaTransactionalObject ref, Function function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        int identityHashCode = ref.___identityHashCode();
        int index = this.indexOf(ref, identityHashCode);
        if (index == -1) {
            BetaTranlocal tranlocal = this.pool.take(ref);
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attach(ref, tranlocal, identityHashCode);
            ++this.size;
            this.hasUpdates = true;
            return;
        }
        BetaTranlocal tranlocal = this.array[index];
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.array[index] = tranlocal;
        }
        throw new TodoException();
    }

    @Override
    public BetaTranlocal get(BetaTransactionalObject ref) {
        int indexOf = this.indexOf(ref, ref.___identityHashCode());
        return indexOf == -1 ? null : this.array[indexOf];
    }

    @Override
    public BetaTranlocal locate(BetaTransactionalObject owner) {
        if (this.status != 1) {
            throw this.abortLocate(owner);
        }
        if (owner == null) {
            throw this.abortLocateWhenNullReference();
        }
        int indexOf = this.indexOf(owner, owner.___identityHashCode());
        return indexOf == -1 ? null : this.array[indexOf];
    }

    public int indexOf(BetaTransactionalObject ref, int hash) {
        int jump = 0;
        boolean goLeft = true;
        do {
            int offset;
            int index;
            BetaTranlocal current;
            if ((current = this.array[index = (hash + (offset = goLeft ? -jump : jump)) % this.array.length]) == null) {
                return -1;
            }
            if (current.owner == ref) {
                return index;
            }
            int currentHash = current.owner.___identityHashCode();
            goLeft = currentHash > hash;
        } while ((jump = jump == 0 ? 1 : jump * 2) < this.array.length);
        return -1;
    }

    private void attach(BetaTransactionalObject ref, BetaTranlocal tranlocal, int hash) {
        int jump = 0;
        boolean goLeft = true;
        do {
            int offset;
            int index;
            BetaTranlocal current;
            if ((current = this.array[index = (hash + (offset = goLeft ? -jump : jump)) % this.array.length]) == null) {
                this.array[index] = tranlocal;
                return;
            }
            int currentHash = current.owner.___identityHashCode();
            goLeft = currentHash > hash;
        } while ((jump = jump == 0 ? 1 : jump * 2) < this.array.length);
        this.expand();
        this.attach(ref, tranlocal, hash);
    }

    private void expand() {
        BetaTranlocal[] oldArray = this.array;
        int newSize = oldArray.length * 2;
        this.array = this.pool.takeTranlocalArray(newSize);
        for (int k = 0; k < oldArray.length; ++k) {
            BetaTranlocal tranlocal = oldArray[k];
            if (tranlocal == null) continue;
            this.attach(tranlocal.owner, tranlocal, tranlocal.owner.___identityHashCode());
        }
        this.pool.putTranlocalArray(oldArray);
    }

    private boolean hasReadConflict() {
        if (this.config.readLockMode != 0 || this.config.inconsistentReadAllowed) {
            return false;
        }
        if (this.hasUntrackedReads) {
            return this.localConflictCounter.syncAndCheckConflict();
        }
        if (this.size == 0) {
            return false;
        }
        if (!this.localConflictCounter.syncAndCheckConflict()) {
            return false;
        }
        for (int k = 0; k < this.array.length; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null || !tranlocal.owner.___hasReadConflict(tranlocal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void abort() {
        switch (this.status) {
            case 1: 
            case 2: {
                this.status = 3;
                if (this.size > 0) {
                    for (int k = 0; k < this.array.length; ++k) {
                        BetaTranlocal tranlocal = this.array[k];
                        if (tranlocal == null) continue;
                        this.array[k] = null;
                        tranlocal.owner.___abort(this, tranlocal, this.pool);
                    }
                }
                if (this.config.permanentListeners != null) {
                    this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostAbort);
                }
                if (this.normalListeners == null) break;
                this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostAbort);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new DeadTransactionException(String.format("[%s] Can't abort an already committed transaction", this.config.familyName));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void commit() {
        if (this.status == 4) {
            return;
        }
        this.prepare();
        Listeners[] listenersArray = null;
        if (this.size > 0) {
            listenersArray = this.config.dirtyCheck ? this.commitDirty() : this.commitAll();
        }
        this.status = 4;
        if (listenersArray != null) {
            Listeners.openAll(listenersArray, this.pool);
        }
        if (this.config.permanentListeners != null) {
            this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostCommit);
        }
        if (this.normalListeners != null) {
            this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostCommit);
        }
    }

    private Listeners[] commitAll() {
        Listeners[] listenersArray = null;
        int listenersArrayIndex = 0;
        for (int k = 0; k < this.array.length; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null) continue;
            this.array[k] = null;
            Listeners listeners = tranlocal.owner.___commitAll(tranlocal, this, this.pool);
            if (listeners == null) continue;
            if (listenersArray == null) {
                int length = this.array.length - k;
                listenersArray = this.pool.takeListenersArray(length);
            }
            listenersArray[listenersArrayIndex] = listeners;
            ++listenersArrayIndex;
        }
        return listenersArray;
    }

    private Listeners[] commitDirty() {
        Listeners[] listenersArray = null;
        int listenersArrayIndex = 0;
        for (int k = 0; k < this.array.length; ++k) {
            Listeners listeners;
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null) continue;
            this.array[k] = null;
            if (!tranlocal.isReadonly() && !tranlocal.isDirty()) {
                tranlocal.calculateIsDirty();
            }
            if ((listeners = tranlocal.owner.___commitDirty(tranlocal, this, this.pool)) == null) continue;
            if (listenersArray == null) {
                int length = this.array.length - k;
                listenersArray = this.pool.takeListenersArray(length);
            }
            listenersArray[listenersArrayIndex] = listeners;
            ++listenersArrayIndex;
        }
        return listenersArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        if (this.status != 1) {
            switch (this.status) {
                case 2: {
                    return;
                }
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        boolean abort = true;
        try {
            if (this.config.permanentListeners != null) {
                this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PrePrepare);
            }
            if (this.normalListeners != null) {
                this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PrePrepare);
            }
            if (this.abortOnly) {
                throw this.abortOnWriteConflict();
            }
            if (this.hasUpdates && this.config.readLockMode != 2) {
                boolean success;
                boolean bl = success = this.config.dirtyCheck ? this.doPrepareDirty() : this.doPrepareAll();
                if (!success) {
                    throw this.abortOnWriteConflict();
                }
            }
            this.status = 2;
            abort = false;
        }
        finally {
            if (abort) {
                this.abort();
            }
        }
    }

    private boolean doPrepareAll() {
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.array.length; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null || tranlocal.prepareAllUpdates(this.pool, this, spinCount)) continue;
            return false;
        }
        return true;
    }

    private boolean doPrepareDirty() {
        int spinCount = this.config.spinCount;
        for (int k = 0; k < this.array.length; ++k) {
            BetaTranlocal tranlocal = this.array[k];
            if (tranlocal == null || tranlocal.prepareDirtyUpdates(this.pool, this, spinCount)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void retry() {
        if (this.status != 1) {
            throw this.abortOnFaultyStatusOfRetry();
        }
        if (!this.config.blockingAllowed) {
            throw this.abortOnNoBlockingAllowed();
        }
        if (this.size == 0) {
            throw this.abortOnNoRetryPossible();
        }
        DefaultRetryLatch listener = this.pool.takeDefaultRetryLatch();
        try {
            long listenerEra = listener.getEra();
            boolean furtherRegistrationNeeded = true;
            boolean atLeastOneRegistration = false;
            for (int k = 0; k < this.array.length; ++k) {
                BetaTranlocal tranlocal = this.array[k];
                if (tranlocal == null) continue;
                this.array[k] = null;
                BetaTransactionalObject owner = tranlocal.owner;
                if (!furtherRegistrationNeeded) continue;
                switch (owner.___registerChangeListener(listener, tranlocal, this.pool, listenerEra)) {
                    case 0: {
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 1: {
                        furtherRegistrationNeeded = false;
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                owner.___abort(this, tranlocal, this.pool);
            }
            this.status = 3;
            if (this.config.permanentListeners != null) {
                this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostAbort);
            }
            if (this.normalListeners != null) {
                this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostAbort);
            }
            if (!atLeastOneRegistration) {
                throw this.abortOnNoRetryPossible();
            }
            this.awaitUpdate(listener);
            throw Retry.INSTANCE;
        }
        catch (Throwable throwable) {
            this.pool.putDefaultRetryLatch(listener);
            throw throwable;
        }
    }

    @Override
    public boolean softReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        if (this.array.length > this.config.minimalArrayTreeSize) {
            this.pool.putTranlocalArray(this.array);
            this.array = this.pool.takeTranlocalArray(this.config.minimalArrayTreeSize);
        }
        this.status = 1;
        this.abortOnly = false;
        this.hasReads = false;
        this.hasUpdates = false;
        this.hasUntrackedReads = false;
        this.size = 0;
        ++this.attempt;
        this.evaluatingCommute = false;
        if (this.normalListeners != null) {
            this.normalListeners.clear();
        }
        return true;
    }

    @Override
    public void hardReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        if (this.array.length > this.config.minimalArrayTreeSize) {
            this.pool.putTranlocalArray(this.array);
            this.array = this.pool.takeTranlocalArray(this.config.minimalArrayTreeSize);
        }
        this.status = 1;
        this.abortOnly = false;
        this.hasUpdates = false;
        this.hasReads = false;
        this.hasUntrackedReads = false;
        this.attempt = 1;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.size = 0;
        this.evaluatingCommute = false;
        if (this.normalListeners != null) {
            this.pool.putArrayList(this.normalListeners);
            this.normalListeners = null;
        }
    }

    @Override
    public void init(BetaTransactionConfiguration transactionConfig) {
        if (transactionConfig == null) {
            this.abort();
            throw new NullPointerException();
        }
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.config = transactionConfig;
        this.hardReset();
    }

    @Override
    public final void startEitherBranch() {
        throw new TodoException();
    }

    @Override
    public final void endEitherBranch() {
        throw new TodoException();
    }

    @Override
    public final void startOrElseBranch() {
        throw new TodoException();
    }
}

