/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.PrototypalFunctionInstance;
import org.mvel2.ast.Safe;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel2.integration.impl.FunctionVariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.integration.impl.StackDemarcResolverFactory;
import org.mvel2.util.ParseTools;

public class Function
extends ASTNode
implements Safe {
    protected String name;
    protected ExecutableStatement compiledBlock;
    protected String[] parameters;
    protected int parmNum;
    protected boolean compiledMode = false;
    protected boolean singleton;

    public Function(String name, char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.name = name;
        if (this.name == null || name.length() == 0) {
            this.name = null;
        }
        this.expr = expr;
        this.parameters = ParseTools.parseParameterDefList(expr, start, offset);
        this.parmNum = this.parameters.length;
        ParserContext ctx = new ParserContext(pCtx.getParserConfiguration(), pCtx, true);
        if (!pCtx.isFunctionContext()) {
            this.singleton = true;
            pCtx.declareFunction(this);
        } else {
            ctx.declareFunction(this);
        }
        for (String s : this.parameters) {
            ctx.addVariable(s, Object.class);
            ctx.addIndexedInput(s);
        }
        ctx.setIndexAllocation(false);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, blockStart, blockOffset);
        compiler.setVerifyOnly(true);
        compiler.compile(ctx);
        ctx.setIndexAllocation(true);
        if (pCtx.getVariables() != null) {
            for (Map.Entry<String, Class> e : pCtx.getVariables().entrySet()) {
                ctx.getVariables().remove(e.getKey());
                ctx.addInput(e.getKey(), e.getValue());
            }
            ctx.processTables();
        }
        ctx.addIndexedInputs(ctx.getVariables().keySet());
        ctx.getVariables().clear();
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, ctx);
        this.parameters = new String[ctx.getIndexedInputs().size()];
        int i = 0;
        for (String s : ctx.getIndexedInputs()) {
            this.parameters[i++] = s;
        }
        this.compiledMode = (fields & 0x10) != 0;
        this.egressType = this.compiledBlock.getKnownEgressType();
        pCtx.addVariable(name, Function.class);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        PrototypalFunctionInstance instance = new PrototypalFunctionInstance(this, new MapVariableResolverFactory());
        if (this.name != null) {
            if (!factory.isIndexedFactory() && factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            factory.createVariable(this.name, instance);
        }
        return instance;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        PrototypalFunctionInstance instance = new PrototypalFunctionInstance(this, new MapVariableResolverFactory());
        if (this.name != null) {
            if (!factory.isIndexedFactory() && factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            factory.createVariable(this.name, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
        if (parms != null && parms.length != 0) {
            FunctionVariableResolverFactory fvrf;
            if (factory instanceof FunctionVariableResolverFactory && ((FunctionVariableResolverFactory)factory).getIndexedVariableResolvers().length == parms.length && (fvrf = (FunctionVariableResolverFactory)factory).getFunction().equals(this)) {
                VariableResolver[] swapVR = fvrf.getIndexedVariableResolvers();
                fvrf.updateParameters(parms);
                try {
                    Object object = this.compiledBlock.getValue(ctx, thisValue, fvrf);
                    return object;
                }
                finally {
                    fvrf.setIndexedVariableResolvers(swapVR);
                }
            }
            return this.compiledBlock.getValue(thisValue, new StackDemarcResolverFactory(new FunctionVariableResolverFactory(this, factory, this.parameters, parms)));
        }
        if (this.compiledMode) {
            return this.compiledBlock.getValue(thisValue, new StackDemarcResolverFactory(new DefaultLocalVariableResolverFactory(factory, this.parameters)));
        }
        return this.compiledBlock.getValue(thisValue, new StackDemarcResolverFactory(new DefaultLocalVariableResolverFactory(factory, this.parameters)));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public void checkArgumentCount(int passing) {
        if (passing != this.parmNum) {
            throw new CompileException("bad number of arguments in function call: " + passing + " (expected: " + (this.parmNum == 0 ? "none" : Integer.valueOf(this.parmNum)) + ")", this.expr, this.start);
        }
    }

    public ExecutableStatement getCompiledBlock() {
        return this.compiledBlock;
    }

    public String toString() {
        return "FunctionDef:" + (this.name == null ? "Anonymous" : this.name);
    }
}

