/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexHashMapWrapper<K, V>
implements Map<K, V> {
    private int indexCounter;
    private final Map<K, ValueContainer<K, V>> wrappedMap;
    private final ArrayList<ValueContainer<K, V>> indexBasedLookup;

    public SimpleIndexHashMapWrapper() {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        this.indexBasedLookup = new ArrayList();
    }

    public SimpleIndexHashMapWrapper(SimpleIndexHashMapWrapper<K, V> wrapper, boolean allocateOnly) {
        this.indexBasedLookup = new ArrayList(wrapper.indexBasedLookup.size());
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        int index = 0;
        if (allocateOnly) {
            for (ValueContainer<K, V> key : wrapper.indexBasedLookup) {
                ValueContainer<K, Object> vc = new ValueContainer<K, Object>(index++, key.getKey(), null);
                this.indexBasedLookup.add(vc);
                this.wrappedMap.put(key.getKey(), vc);
            }
        } else {
            for (ValueContainer<K, V> key : wrapper.indexBasedLookup) {
                ValueContainer<K, V> vc = new ValueContainer<K, V>(index++, key.getKey(), key.getValue());
                this.indexBasedLookup.add(vc);
                this.wrappedMap.put(key.getKey(), vc);
            }
        }
    }

    public SimpleIndexHashMapWrapper(K[] keys) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(keys.length * 2);
        this.indexBasedLookup = new ArrayList(keys.length);
        this.initWithKeys(keys);
    }

    public SimpleIndexHashMapWrapper(K[] keys, int initialCapacity, float load) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(initialCapacity * 2, load);
        this.indexBasedLookup = new ArrayList(initialCapacity);
        this.initWithKeys(keys);
    }

    public void initWithKeys(K[] keys) {
        int index = 0;
        for (K key : keys) {
            ValueContainer<K, Object> vc = new ValueContainer<K, Object>(index++, key, null);
            this.wrappedMap.put(key, vc);
            this.indexBasedLookup.add(vc);
        }
    }

    public void addKey(K key) {
        ValueContainer<K, Object> vc = new ValueContainer<K, Object>(this.indexCounter++, key, null);
        this.indexBasedLookup.add(vc);
        this.wrappedMap.put(key, vc);
    }

    public void addKey(K key, V value) {
        ValueContainer<K, V> vc = new ValueContainer<K, V>(this.indexCounter++, key, value);
        this.indexBasedLookup.add(vc);
        this.wrappedMap.put(key, vc);
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(key).getValue();
    }

    public V getByIndex(int index) {
        return this.indexBasedLookup.get(index).getValue();
    }

    public K getKeyAtIndex(int index) {
        return this.indexBasedLookup.get(index).getKey();
    }

    public int indexOf(K key) {
        return this.wrappedMap.get(key).getIndex();
    }

    @Override
    public V put(K key, V value) {
        ValueContainer<K, V> vc = this.wrappedMap.get(key);
        if (vc == null) {
            throw new RuntimeException("cannot add a new entry.  you must allocate a new key with addKey() first.");
        }
        this.indexBasedLookup.add(vc);
        return this.wrappedMap.put(key, vc).getValue();
    }

    public void putAtIndex(int index, V value) {
        ValueContainer<K, V> vc = this.indexBasedLookup.get(index);
        vc.setValue(value);
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("cannot remove keys");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("cannot clear map");
    }

    @Override
    public Set<K> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueContainer<K, V> {
        private int index;
        private K key;
        private V value;

        public ValueContainer(int index, K key, V value) {
            this.index = index;
            this.key = key;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        void setKey(K key) {
            this.key = key;
        }

        void setValue(V value) {
            this.value = value;
        }
    }
}

