/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.databind.introspect;

import java.lang.reflect.Type;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.type.TypeBindings;
import org.nd4j.shade.jackson.databind.type.TypeFactory;

public interface TypeResolutionContext {
    public JavaType resolveType(Type var1);

    public static class Empty
    implements TypeResolutionContext {
        private final TypeFactory _typeFactory;

        public Empty(TypeFactory tf) {
            this._typeFactory = tf;
        }

        @Override
        public JavaType resolveType(Type type) {
            return this._typeFactory.constructType(type);
        }
    }

    public static class Basic
    implements TypeResolutionContext {
        private final TypeFactory _typeFactory;
        private final TypeBindings _bindings;

        public Basic(TypeFactory tf, TypeBindings b) {
            this._typeFactory = tf;
            this._bindings = b;
        }

        @Override
        public JavaType resolveType(Type type) {
            return this._typeFactory.resolveMemberType(type, this._bindings);
        }
    }
}

