/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners.checkpoint;

import java.io.Serializable;
import java.util.Arrays;

public class Checkpoint
implements Serializable {
    private int checkpointNum;
    private long timestamp;
    private int iteration;
    private int epoch;
    private String filename;

    public static String getFileHeader() {
        return "checkpointNum,timestamp,iteration,epoch,filename";
    }

    public static Checkpoint fromFileString(String str) {
        Object[] split = str.split(",");
        if (split.length != 5) {
            throw new IllegalStateException("Cannot parse checkpoint entry: expected 5 entries, got " + split.length + " - values = " + Arrays.toString(split));
        }
        return new Checkpoint(Integer.parseInt(split[0]), Long.parseLong((String)split[1]), Integer.parseInt((String)split[2]), Integer.parseInt((String)split[3]), (String)split[4]);
    }

    public String toFileString() {
        return this.checkpointNum + "," + this.timestamp + "," + this.iteration + "," + this.epoch + "," + this.filename;
    }

    public Checkpoint(int checkpointNum, long timestamp, int iteration, int epoch, String filename) {
        this.checkpointNum = checkpointNum;
        this.timestamp = timestamp;
        this.iteration = iteration;
        this.epoch = epoch;
        this.filename = filename;
    }

    public int getCheckpointNum() {
        return this.checkpointNum;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setCheckpointNum(int checkpointNum) {
        this.checkpointNum = checkpointNum;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCheckpointNum() != other.getCheckpointNum()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getIteration() != other.getIteration()) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Checkpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCheckpointNum();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getIteration();
        result = result * 59 + this.getEpoch();
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    public String toString() {
        return "Checkpoint(checkpointNum=" + this.getCheckpointNum() + ", timestamp=" + this.getTimestamp() + ", iteration=" + this.getIteration() + ", epoch=" + this.getEpoch() + ", filename=" + this.getFilename() + ")";
    }
}

