/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import org.nd4j.autodiff.samediff.internal.IDependencyMap;

public class DependencMapLinkedHash<K, V>
implements IDependencyMap<K, V> {
    private HashMap<K, HashSet<V>> map = new LinkedHashMap<K, HashSet<V>>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void add(K dependeeGroup, V element) {
        HashSet<Object> s = this.map.get(dependeeGroup);
        if (s == null) {
            s = new HashSet();
            this.map.put(dependeeGroup, s);
        }
        s.add(element);
    }

    @Override
    public Iterable<V> getDependantsForEach(K dependeeGroup) {
        return this.map.get(dependeeGroup);
    }

    @Override
    public Iterable<V> getDependantsForGroup(K dependeeGroup) {
        return this.map.get(dependeeGroup);
    }

    @Override
    public boolean containsAny(K dependeeGroup) {
        return this.map.containsKey(dependeeGroup);
    }

    @Override
    public boolean containsAnyForGroup(K dependeeGroup) {
        return this.map.containsKey(dependeeGroup);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void removeGroup(K dependeeGroup) {
        this.map.remove(dependeeGroup);
    }

    @Override
    public Iterable<V> removeGroupReturn(K dependeeGroup) {
        return this.map.remove(dependeeGroup);
    }

    @Override
    public void removeForEach(K dependeeGroup) {
        this.map.remove(dependeeGroup);
    }

    @Override
    public Iterable<V> removeForEachResult(K dependeeGroup) {
        return this.map.remove(dependeeGroup);
    }

    @Override
    public Iterable<V> removeGroupReturn(K dependeeGroup, Predicate<V> predicate) {
        HashSet<V> s = new HashSet<V>();
        HashSet<V> ret = this.map.get(dependeeGroup);
        if (ret != null) {
            long prevSize = ret.size();
            for (Object v : ret) {
                if (!predicate.test(v)) continue;
                s.add(v);
            }
            for (Object v : s) {
                ret.remove(s);
            }
            if (prevSize == (long)s.size()) {
                this.map.remove(dependeeGroup);
            }
        }
        return s;
    }
}

