/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Pooling3DConfig
extends BaseConvolutionConfig {
    private long kD;
    private long kW;
    private long kH;
    private long sD;
    private long sW;
    private long sH;
    private long pD;
    private long pW;
    private long pH;
    private long dD;
    private long dW;
    private long dH;
    private Pooling3D.Pooling3DType type;
    private boolean isSameMode;
    private boolean isNCDHW;

    public Pooling3DConfig(long kD, long kW, long kH, long sD, long sW, long sH, long pD, long pW, long pH, long dD, long dW, long dH, Pooling3D.Pooling3DType type, boolean isSameMode, boolean isNCDHW) {
        this.kD = kD;
        this.kW = kW;
        this.kH = kH;
        this.sD = sD;
        this.sW = sW;
        this.sH = sH;
        this.pD = pD;
        this.pW = pW;
        this.pH = pH;
        this.dD = dD;
        this.dW = dW;
        this.dH = dH;
        this.type = type;
        this.isSameMode = isSameMode;
        this.isNCDHW = isNCDHW;
        this.validate();
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kD", this.kD);
        ret.put("kW", this.kW);
        ret.put("kH", this.kH);
        ret.put("sD", this.sD);
        ret.put("sW", this.sW);
        ret.put("sH", this.sH);
        ret.put("pD", this.pD);
        ret.put("pW", this.pW);
        ret.put("pH", this.pH);
        ret.put("dD", this.dD);
        ret.put("dW", this.dW);
        ret.put("dH", this.dH);
        ret.put("type", this.type.toString());
        ret.put("isSameMode", this.isSameMode);
        ret.put("isNCDHW", this.isNCDHW);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate3D(this.kH, this.kW, this.kD, this.sH, this.sW, this.sD, this.pH, this.pW, this.pD, this.dH, this.dW, this.dD);
    }

    private static long $default$kD() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$sD() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$pD() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$dD() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static Pooling3D.Pooling3DType $default$type() {
        return Pooling3D.Pooling3DType.MAX;
    }

    private static boolean $default$isNCDHW() {
        return true;
    }

    public static Pooling3DConfigBuilder builder() {
        return new Pooling3DConfigBuilder();
    }

    public long getKD() {
        return this.kD;
    }

    public long getKW() {
        return this.kW;
    }

    public long getKH() {
        return this.kH;
    }

    public long getSD() {
        return this.sD;
    }

    public long getSW() {
        return this.sW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getPD() {
        return this.pD;
    }

    public long getPW() {
        return this.pW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getDD() {
        return this.dD;
    }

    public long getDW() {
        return this.dW;
    }

    public long getDH() {
        return this.dH;
    }

    public Pooling3D.Pooling3DType getType() {
        return this.type;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public boolean isNCDHW() {
        return this.isNCDHW;
    }

    public void setKD(long kD) {
        this.kD = kD;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setSD(long sD) {
        this.sD = sD;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setPD(long pD) {
        this.pD = pD;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setDD(long dD) {
        this.dD = dD;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setType(Pooling3D.Pooling3DType type) {
        this.type = type;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public void setNCDHW(boolean isNCDHW) {
        this.isNCDHW = isNCDHW;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pooling3DConfig)) {
            return false;
        }
        Pooling3DConfig other = (Pooling3DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKD() != other.getKD()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getSD() != other.getSD()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getPD() != other.getPD()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getDD() != other.getDD()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.isSameMode() != other.isSameMode()) {
            return false;
        }
        if (this.isNCDHW() != other.isNCDHW()) {
            return false;
        }
        Pooling3D.Pooling3DType this$type = this.getType();
        Pooling3D.Pooling3DType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pooling3DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kD = this.getKD();
        result = result * 59 + (int)($kD >>> 32 ^ $kD);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $sD = this.getSD();
        result = result * 59 + (int)($sD >>> 32 ^ $sD);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $pD = this.getPD();
        result = result * 59 + (int)($pD >>> 32 ^ $pD);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $dD = this.getDD();
        result = result * 59 + (int)($dD >>> 32 ^ $dD);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        result = result * 59 + (this.isNCDHW() ? 79 : 97);
        Pooling3D.Pooling3DType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Pooling3DConfig(kD=" + this.getKD() + ", kW=" + this.getKW() + ", kH=" + this.getKH() + ", sD=" + this.getSD() + ", sW=" + this.getSW() + ", sH=" + this.getSH() + ", pD=" + this.getPD() + ", pW=" + this.getPW() + ", pH=" + this.getPH() + ", dD=" + this.getDD() + ", dW=" + this.getDW() + ", dH=" + this.getDH() + ", type=" + this.getType() + ", isSameMode=" + this.isSameMode() + ", isNCDHW=" + this.isNCDHW() + ")";
    }

    public Pooling3DConfig() {
        this.kD = Pooling3DConfig.$default$kD();
        this.kW = Pooling3DConfig.$default$kW();
        this.kH = Pooling3DConfig.$default$kH();
        this.sD = Pooling3DConfig.$default$sD();
        this.sW = Pooling3DConfig.$default$sW();
        this.sH = Pooling3DConfig.$default$sH();
        this.pD = Pooling3DConfig.$default$pD();
        this.pW = Pooling3DConfig.$default$pW();
        this.pH = Pooling3DConfig.$default$pH();
        this.dD = Pooling3DConfig.$default$dD();
        this.dW = Pooling3DConfig.$default$dW();
        this.dH = Pooling3DConfig.$default$dH();
        this.type = Pooling3DConfig.$default$type();
        this.isNCDHW = Pooling3DConfig.$default$isNCDHW();
    }

    public static class Pooling3DConfigBuilder {
        private boolean kD$set;
        private long kD$value;
        private boolean kW$set;
        private long kW$value;
        private boolean kH$set;
        private long kH$value;
        private boolean sD$set;
        private long sD$value;
        private boolean sW$set;
        private long sW$value;
        private boolean sH$set;
        private long sH$value;
        private boolean pD$set;
        private long pD$value;
        private boolean pW$set;
        private long pW$value;
        private boolean pH$set;
        private long pH$value;
        private boolean dD$set;
        private long dD$value;
        private boolean dW$set;
        private long dW$value;
        private boolean dH$set;
        private long dH$value;
        private boolean type$set;
        private Pooling3D.Pooling3DType type$value;
        private boolean isSameMode;
        private boolean isNCDHW$set;
        private boolean isNCDHW$value;

        Pooling3DConfigBuilder() {
        }

        public Pooling3DConfigBuilder kD(long kD) {
            this.kD$value = kD;
            this.kD$set = true;
            return this;
        }

        public Pooling3DConfigBuilder kW(long kW) {
            this.kW$value = kW;
            this.kW$set = true;
            return this;
        }

        public Pooling3DConfigBuilder kH(long kH) {
            this.kH$value = kH;
            this.kH$set = true;
            return this;
        }

        public Pooling3DConfigBuilder sD(long sD) {
            this.sD$value = sD;
            this.sD$set = true;
            return this;
        }

        public Pooling3DConfigBuilder sW(long sW) {
            this.sW$value = sW;
            this.sW$set = true;
            return this;
        }

        public Pooling3DConfigBuilder sH(long sH) {
            this.sH$value = sH;
            this.sH$set = true;
            return this;
        }

        public Pooling3DConfigBuilder pD(long pD) {
            this.pD$value = pD;
            this.pD$set = true;
            return this;
        }

        public Pooling3DConfigBuilder pW(long pW) {
            this.pW$value = pW;
            this.pW$set = true;
            return this;
        }

        public Pooling3DConfigBuilder pH(long pH) {
            this.pH$value = pH;
            this.pH$set = true;
            return this;
        }

        public Pooling3DConfigBuilder dD(long dD) {
            this.dD$value = dD;
            this.dD$set = true;
            return this;
        }

        public Pooling3DConfigBuilder dW(long dW) {
            this.dW$value = dW;
            this.dW$set = true;
            return this;
        }

        public Pooling3DConfigBuilder dH(long dH) {
            this.dH$value = dH;
            this.dH$set = true;
            return this;
        }

        public Pooling3DConfigBuilder type(Pooling3D.Pooling3DType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public Pooling3DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode = isSameMode;
            return this;
        }

        public Pooling3DConfigBuilder isNCDHW(boolean isNCDHW) {
            this.isNCDHW$value = isNCDHW;
            this.isNCDHW$set = true;
            return this;
        }

        public Pooling3DConfig build() {
            long kD$value = this.kD$value;
            if (!this.kD$set) {
                kD$value = Pooling3DConfig.$default$kD();
            }
            long kW$value = this.kW$value;
            if (!this.kW$set) {
                kW$value = Pooling3DConfig.$default$kW();
            }
            long kH$value = this.kH$value;
            if (!this.kH$set) {
                kH$value = Pooling3DConfig.$default$kH();
            }
            long sD$value = this.sD$value;
            if (!this.sD$set) {
                sD$value = Pooling3DConfig.$default$sD();
            }
            long sW$value = this.sW$value;
            if (!this.sW$set) {
                sW$value = Pooling3DConfig.$default$sW();
            }
            long sH$value = this.sH$value;
            if (!this.sH$set) {
                sH$value = Pooling3DConfig.$default$sH();
            }
            long pD$value = this.pD$value;
            if (!this.pD$set) {
                pD$value = Pooling3DConfig.$default$pD();
            }
            long pW$value = this.pW$value;
            if (!this.pW$set) {
                pW$value = Pooling3DConfig.$default$pW();
            }
            long pH$value = this.pH$value;
            if (!this.pH$set) {
                pH$value = Pooling3DConfig.$default$pH();
            }
            long dD$value = this.dD$value;
            if (!this.dD$set) {
                dD$value = Pooling3DConfig.$default$dD();
            }
            long dW$value = this.dW$value;
            if (!this.dW$set) {
                dW$value = Pooling3DConfig.$default$dW();
            }
            long dH$value = this.dH$value;
            if (!this.dH$set) {
                dH$value = Pooling3DConfig.$default$dH();
            }
            Pooling3D.Pooling3DType type$value = this.type$value;
            if (!this.type$set) {
                type$value = Pooling3DConfig.$default$type();
            }
            boolean isNCDHW$value = this.isNCDHW$value;
            if (!this.isNCDHW$set) {
                isNCDHW$value = Pooling3DConfig.$default$isNCDHW();
            }
            return new Pooling3DConfig(kD$value, kW$value, kH$value, sD$value, sW$value, sH$value, pD$value, pW$value, pH$value, dD$value, dW$value, dH$value, type$value, this.isSameMode, isNCDHW$value);
        }

        public String toString() {
            return "Pooling3DConfig.Pooling3DConfigBuilder(kD$value=" + this.kD$value + ", kW$value=" + this.kW$value + ", kH$value=" + this.kH$value + ", sD$value=" + this.sD$value + ", sW$value=" + this.sW$value + ", sH$value=" + this.sH$value + ", pD$value=" + this.pD$value + ", pW$value=" + this.pW$value + ", pH$value=" + this.pH$value + ", dD$value=" + this.dD$value + ", dW$value=" + this.dW$value + ", dH$value=" + this.dH$value + ", type$value=" + this.type$value + ", isSameMode=" + this.isSameMode + ", isNCDHW$value=" + this.isNCDHW$value + ")";
        }
    }
}

