/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.List;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;
import org.nd4j.linalg.api.ops.impl.loss.bp.CosineDistanceLossBp;

public class CosineDistanceLoss
extends BaseLoss {
    protected int dimension;

    public CosineDistanceLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable predictions, SDVariable weights, SDVariable labels, int dimension) {
        super(sameDiff, lossReduce, predictions, weights, labels);
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    public CosineDistanceLoss(SameDiff sameDiff, SDVariable labels, SDVariable predictions, SDVariable weights, LossReduce lossReduce, int dimension) {
        this(sameDiff, lossReduce, predictions, weights, labels, dimension);
    }

    public CosineDistanceLoss(INDArray labels, INDArray predictions, INDArray weights, LossReduce lossReduce, int dimension) {
        super(lossReduce, predictions, weights, labels);
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    public CosineDistanceLoss() {
    }

    @Override
    public String opName() {
        return "cosine_distance_loss";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        if (this.iArguments.size() > 1) {
            this.dimension = ((Long)this.iArguments.get(this.iArguments.size() - 1)).intValue();
        }
        return new CosineDistanceLossBp(this.sameDiff, this.lossReduce, this.arg(0), this.arg(1), this.arg(2), this.dimension).outputs();
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }
}

