/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.adapter;

import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class MultiDataSetIteratorAdapter
implements MultiDataSetIterator {
    private DataSetIterator iter;
    private MultiDataSetPreProcessor preProcessor;

    public MultiDataSetIteratorAdapter(DataSetIterator iter) {
        this.iter = iter;
    }

    @Override
    public MultiDataSet next(int i) {
        MultiDataSet mds = this.iter.next(i).toMultiDataSet();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(mds);
        }
        return mds;
    }

    @Override
    public void setPreProcessor(MultiDataSetPreProcessor multiDataSetPreProcessor) {
        this.preProcessor = multiDataSetPreProcessor;
    }

    @Override
    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public boolean resetSupported() {
        return this.iter.resetSupported();
    }

    @Override
    public boolean asyncSupported() {
        return this.iter.asyncSupported();
    }

    @Override
    public void reset() {
        this.iter.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public MultiDataSet next() {
        MultiDataSet mds = ((DataSet)this.iter.next()).toMultiDataSet();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(mds);
        }
        return mds;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

