/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class ImageFlatteningDataSetPreProcessor
implements DataSetPreProcessor {
    @Override
    public void preProcess(DataSet toPreProcess) {
        INDArray input = toPreProcess.getFeatures();
        if (input.rank() == 2) {
            return;
        }
        if (input.ordering() != 'c' || !Shape.strideDescendingCAscendingF(input)) {
            input = input.dup('c');
        }
        long[] inShape = input.shape();
        long[] outShape = new long[]{inShape[0], inShape[1] * inShape[2] * inShape[3]};
        INDArray reshaped = input.reshape('c', outShape);
        toPreProcess.setFeatures(reshaped);
    }
}

