/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.heartbeat.reports;

public class Task {
    private NetworkType networkType;
    private ArchitectureType architectureType;
    private int numFeatures;
    private int numLabels;
    private int numSamples;

    public String toCompactString() {
        StringBuilder builder = new StringBuilder();
        builder.append("F: ").append(this.numFeatures).append("/");
        builder.append("L: ").append(this.numLabels).append("/");
        builder.append("S: ").append(this.numSamples).append(" ");
        return builder.toString();
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public ArchitectureType getArchitectureType() {
        return this.architectureType;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNetworkType(NetworkType networkType) {
        this.networkType = networkType;
    }

    public void setArchitectureType(ArchitectureType architectureType) {
        this.architectureType = architectureType;
    }

    public void setNumFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
    }

    public void setNumLabels(int numLabels) {
        this.numLabels = numLabels;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumFeatures() != other.getNumFeatures()) {
            return false;
        }
        if (this.getNumLabels() != other.getNumLabels()) {
            return false;
        }
        if (this.getNumSamples() != other.getNumSamples()) {
            return false;
        }
        NetworkType this$networkType = this.getNetworkType();
        NetworkType other$networkType = other.getNetworkType();
        if (this$networkType == null ? other$networkType != null : !((Object)((Object)this$networkType)).equals((Object)other$networkType)) {
            return false;
        }
        ArchitectureType this$architectureType = this.getArchitectureType();
        ArchitectureType other$architectureType = other.getArchitectureType();
        return !(this$architectureType == null ? other$architectureType != null : !((Object)((Object)this$architectureType)).equals((Object)other$architectureType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumFeatures();
        result = result * 59 + this.getNumLabels();
        result = result * 59 + this.getNumSamples();
        NetworkType $networkType = this.getNetworkType();
        result = result * 59 + ($networkType == null ? 43 : ((Object)((Object)$networkType)).hashCode());
        ArchitectureType $architectureType = this.getArchitectureType();
        result = result * 59 + ($architectureType == null ? 43 : ((Object)((Object)$architectureType)).hashCode());
        return result;
    }

    public String toString() {
        return "Task(networkType=" + this.getNetworkType() + ", architectureType=" + this.getArchitectureType() + ", numFeatures=" + this.getNumFeatures() + ", numLabels=" + this.getNumLabels() + ", numSamples=" + this.getNumSamples() + ")";
    }

    public static enum ArchitectureType {
        CONVOLUTION,
        RECURRENT,
        RBM,
        WORDVECTORS,
        UNKNOWN;

    }

    public static enum NetworkType {
        MultilayerNetwork,
        ComputationalGraph,
        DenseNetwork;

    }
}

