/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.RmsProp;

public class RmsPropUpdater
implements GradientUpdater<RmsProp> {
    public static final String G_STATE = "G";
    private final RmsProp config;
    private INDArray lastGradient;
    private char gradientReshapeOrder;

    public RmsPropUpdater(RmsProp config) {
        this.config = config;
    }

    @Override
    public void setState(@NonNull Map<String, INDArray> stateMap, boolean initialize) {
        if (stateMap == null) {
            throw new NullPointerException("stateMap is marked non-null but is null");
        }
        if (!stateMap.containsKey(G_STATE) || stateMap.size() != 1) {
            throw new IllegalStateException("State map should contain only key [G] but has keys " + stateMap.keySet());
        }
        this.lastGradient = stateMap.get(G_STATE);
    }

    @Override
    public Map<String, INDArray> getState() {
        return Collections.singletonMap(G_STATE, this.lastGradient);
    }

    @Override
    public void setStateViewArray(INDArray viewArray, long[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVectorOrScalar()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(this.config.getEpsilon());
        }
        this.lastGradient = viewArray;
        this.lastGradient = Shape.newShapeNoCopy(this.lastGradient, gradientShape, gradientOrder == 'f');
        if (this.lastGradient == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view array");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.lastGradient == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double learningRate = this.config.getLearningRate(iteration, epoch);
        double rmsDecay = this.config.getRmsDecay();
        double epsilon = this.config.getEpsilon();
        Nd4j.exec(new org.nd4j.linalg.api.ops.impl.updaters.RmsPropUpdater(gradient.reshape(this.lastGradient.shape()), this.lastGradient, learningRate, rmsDecay, epsilon));
    }

    @Override
    public RmsProp getConfig() {
        return this.config;
    }

    public INDArray getLastGradient() {
        return this.lastGradient;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setLastGradient(INDArray lastGradient) {
        this.lastGradient = lastGradient;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsPropUpdater)) {
            return false;
        }
        RmsPropUpdater other = (RmsPropUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGradientReshapeOrder() != other.getGradientReshapeOrder()) {
            return false;
        }
        RmsProp this$config = this.getConfig();
        RmsProp other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$lastGradient = this.getLastGradient();
        INDArray other$lastGradient = other.getLastGradient();
        return !(this$lastGradient == null ? other$lastGradient != null : !this$lastGradient.equals(other$lastGradient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsPropUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGradientReshapeOrder();
        RmsProp $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $lastGradient = this.getLastGradient();
        result = result * 59 + ($lastGradient == null ? 43 : $lastGradient.hashCode());
        return result;
    }

    public String toString() {
        return "RmsPropUpdater(config=" + this.getConfig() + ", lastGradient=" + this.getLastGradient() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

