/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;

public class RampSchedule
implements ISchedule {
    protected final ISchedule baseSchedule;
    protected final int numIter;

    public RampSchedule(ISchedule baseSchedule, int numIter) {
        this.baseSchedule = baseSchedule;
        this.numIter = numIter;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        double base = this.baseSchedule.valueAt(iteration, epoch);
        if (iteration >= this.numIter - 1) {
            return base;
        }
        double frac = (double)(iteration + 1) / (double)this.numIter;
        return frac * base;
    }

    @Override
    public ISchedule clone() {
        return new RampSchedule(this.baseSchedule.clone(), this.numIter);
    }
}

