/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class SigmoidSchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialValue;
    private final double gamma;
    private final int stepSize;

    public SigmoidSchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialValue") double initialValue, @JsonProperty(value="gamma") double gamma, @JsonProperty(value="stepSize") int stepSize) {
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.gamma = gamma;
        this.stepSize = stepSize;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        return this.initialValue / (1.0 + Math.exp(-this.gamma * (double)(i - this.stepSize)));
    }

    @Override
    public ISchedule clone() {
        return new SigmoidSchedule(this.scheduleType, this.initialValue, this.gamma, this.stepSize);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getGamma() {
        return this.gamma;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmoidSchedule)) {
            return false;
        }
        SigmoidSchedule other = (SigmoidSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
            return false;
        }
        if (this.getStepSize() != other.getStepSize()) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        return !(this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SigmoidSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialValue = Double.doubleToLongBits(this.getInitialValue());
        result = result * 59 + (int)($initialValue >>> 32 ^ $initialValue);
        long $gamma = Double.doubleToLongBits(this.getGamma());
        result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
        result = result * 59 + this.getStepSize();
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        return result;
    }

    public String toString() {
        return "SigmoidSchedule(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", gamma=" + this.getGamma() + ", stepSize=" + this.getStepSize() + ")";
    }
}

