/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.string;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class NDArrayStrings {
    public static final String EMPTY_ARRAY_STR = "[]";
    private static final String[] OPEN_BRACKETS = new String[]{"", "[", "[[", "[[[", "[[[[", "[[[[[", "[[[[[[", "[[[[[[[", "[[[[[[[["};
    private static final String[] CLOSE_BRACKETS = new String[]{"", "]", "]]", "]]]", "]]]]", "]]]]]", "]]]]]]", "]]]]]]]", "]]]]]]]]"};
    public static final long DEFAULT_MAX_PRINT_ELEMENTS = 1000L;
    private static long maxPrintElements = 1000L;
    private long localMaxPrintElements = maxPrintElements;
    private String colSep = ",";
    private String newLineSep = ",";
    private int padding = 7;
    private int precision = 4;
    private double minToPrintWithoutSwitching;
    private double maxToPrintWithoutSwitching;
    private String scientificFormat = "";
    private DecimalFormat decimalFormat;
    private boolean dontOverrideFormat = false;

    public NDArrayStrings() {
        this(",", 4);
    }

    public NDArrayStrings(String colSep) {
        this(colSep, 4);
    }

    public NDArrayStrings(int precision) {
        this(",", precision);
    }

    public NDArrayStrings(long maxElements, int precision) {
        this(",", precision);
        this.localMaxPrintElements = maxElements;
    }

    public NDArrayStrings(long maxElements) {
        this();
        this.localMaxPrintElements = maxElements;
    }

    public NDArrayStrings(long maxElements, boolean forceSummarize, int precision) {
        this(",", precision);
        this.localMaxPrintElements = forceSummarize ? 0L : maxElements;
    }

    public NDArrayStrings(boolean forceSummarize, int precision) {
        this(",", precision);
        if (forceSummarize) {
            this.localMaxPrintElements = 0L;
        }
    }

    public NDArrayStrings(boolean forceSummarize) {
        this(",", 4);
        if (forceSummarize) {
            this.localMaxPrintElements = 0L;
        }
    }

    public NDArrayStrings(String colSep, int precision) {
        boolean useHash;
        int prec;
        this.colSep = colSep;
        if (!colSep.replaceAll("\\s", "").equals(",")) {
            this.newLineSep = "";
        }
        StringBuilder decFormatNum = new StringBuilder("0.");
        this.precision = prec = Math.abs(precision);
        boolean bl = useHash = precision < 0;
        while (prec > 0) {
            decFormatNum.append(useHash ? "#" : "0");
            --prec;
        }
        this.decimalFormat = this.localeIndifferentDecimalFormat(decFormatNum.toString());
    }

    public NDArrayStrings(String colSep, String decFormat) {
        this.colSep = colSep;
        this.decimalFormat = this.localeIndifferentDecimalFormat(decFormat);
        this.padding = decFormat.toUpperCase().contains("E") ? decFormat.length() + 3 : decFormat.length() + 1;
        this.dontOverrideFormat = true;
    }

    public String format(INDArray arr) {
        return this.format(arr, true);
    }

    public String format(INDArray arr, boolean summarize) {
        if (arr.isEmpty()) {
            return EMPTY_ARRAY_STR;
        }
        this.scientificFormat = "0.";
        for (int addPrecision = this.precision; addPrecision > 0; --addPrecision) {
            this.scientificFormat = this.scientificFormat + "#";
        }
        this.scientificFormat = this.scientificFormat + "E0";
        if (this.scientificFormat.length() + 2 > this.padding) {
            this.padding = this.scientificFormat.length() + 2;
        }
        this.maxToPrintWithoutSwitching = Math.pow(10.0, this.precision);
        this.minToPrintWithoutSwitching = 1.0 / this.maxToPrintWithoutSwitching;
        return this.format(arr, 0, summarize && arr.length() > this.localMaxPrintElements);
    }

    private String format(INDArray arr, int offset, boolean summarize) {
        int rank = arr.rank();
        if (arr.isScalar() || arr.length() == 1L) {
            int fRank = Math.min(rank, OPEN_BRACKETS.length - 1);
            if (arr.isR()) {
                double arrElement = arr.getDouble(0L);
                if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                    String asString = this.localeIndifferentDecimalFormat(this.scientificFormat).format(arrElement);
                    asString = asString.replace('E', 'e');
                    return OPEN_BRACKETS[fRank] + asString + CLOSE_BRACKETS[fRank];
                }
                if (arr.getDouble(0L) == 0.0) {
                    return OPEN_BRACKETS[fRank] + "0" + CLOSE_BRACKETS[fRank];
                }
                return OPEN_BRACKETS[fRank] + this.decimalFormat.format(arr.getDouble(0L)) + CLOSE_BRACKETS[fRank];
            }
            if (arr.isZ()) {
                long arrElement = arr.getLong(0L);
                return OPEN_BRACKETS[fRank] + arrElement + CLOSE_BRACKETS[fRank];
            }
            if (arr.isB()) {
                long arrElement = arr.getLong(0L);
                return OPEN_BRACKETS[fRank] + (arrElement == 0L ? "false" : "true") + CLOSE_BRACKETS[fRank];
            }
            if (arr.dataType() == DataType.UTF8) {
                String s = arr.getString(0L);
                return OPEN_BRACKETS[fRank] + "\"" + s.replaceAll("\n", "\\n") + "\"" + CLOSE_BRACKETS[fRank];
            }
            throw new ND4JIllegalStateException();
        }
        if (rank == 1) {
            return this.vectorToString(arr, summarize);
        }
        if (arr.isRowVector()) {
            if (offset == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(this.vectorToString(arr, summarize));
                sb.append("]");
                return sb.toString();
            }
            return this.vectorToString(arr, summarize);
        }
        ++offset;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long nSlices = arr.slices();
        int i = 0;
        while ((long)i < nSlices) {
            if (summarize && i > 2 && (long)i < nSlices - 3L) {
                sb.append(" ...");
                sb.append(this.newLineSep).append(" \n");
                sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                sb.append(StringUtils.repeat((String)" ", (int)offset));
                i = Math.max(i, (int)nSlices - 4);
            } else {
                if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                    sb.append("[");
                }
                if (arr.ordering() == 'f' && arr.rank() > 2 && arr.size(arr.rank() - 1) == 1L) {
                    sb.append(this.format(arr.dup('c').slice(i), offset, summarize));
                } else {
                    INDArray slice = arr.slice(i);
                    sb.append(this.format(slice, offset, summarize));
                }
                if ((long)i != nSlices - 1L) {
                    if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                        sb.append("]");
                    }
                    sb.append(this.newLineSep).append(" \n");
                    sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                    sb.append(StringUtils.repeat((String)" ", (int)offset));
                } else if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                    sb.append("]");
                }
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private String vectorToString(INDArray arr, boolean summarize) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long l = arr.length();
        int i = 0;
        while ((long)i < l) {
            if (summarize && i > 2 && (long)i < l - 3L) {
                sb.append("  ...");
                i = Math.max(i, (int)l - 4);
            } else if (arr.isR()) {
                double arrElement = arr.getDouble((long)i);
                if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                    String asString = this.localeIndifferentDecimalFormat(this.scientificFormat).format(arrElement);
                    asString = asString.replace('E', 'e');
                    sb.append(String.format("%1$" + this.padding + "s", asString));
                } else if (arrElement == 0.0) {
                    sb.append(String.format("%1$" + this.padding + "s", 0));
                } else {
                    sb.append(String.format("%1$" + this.padding + "s", this.decimalFormat.format(arrElement)));
                }
            } else if (arr.isZ()) {
                long arrElement = arr.getLong((long)i);
                sb.append(String.format("%1$" + this.padding + "s", arrElement));
            } else if (arr.isB()) {
                long arrElement = arr.getLong((long)i);
                sb.append(String.format("%1$" + this.padding + "s", arrElement == 0L ? "false" : "true"));
            } else if (arr.dataType() == DataType.UTF8) {
                Object s = arr.getString(i);
                s = "\"" + ((String)s).replaceAll("\n", "\\n") + "\"";
                sb.append((String)s);
            }
            if ((long)i < l - 1L && (!summarize || i <= 2 || (long)i >= l - 3L || summarize && l == 6L)) {
                sb.append(this.colSep);
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private DecimalFormat localeIndifferentDecimalFormat(String pattern) {
        return new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.US));
    }

    public long getLocalMaxPrintElements() {
        return this.localMaxPrintElements;
    }

    public String getColSep() {
        return this.colSep;
    }

    public String getNewLineSep() {
        return this.newLineSep;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getPrecision() {
        return this.precision;
    }

    public double getMinToPrintWithoutSwitching() {
        return this.minToPrintWithoutSwitching;
    }

    public double getMaxToPrintWithoutSwitching() {
        return this.maxToPrintWithoutSwitching;
    }

    public String getScientificFormat() {
        return this.scientificFormat;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public boolean isDontOverrideFormat() {
        return this.dontOverrideFormat;
    }

    public void setLocalMaxPrintElements(long localMaxPrintElements) {
        this.localMaxPrintElements = localMaxPrintElements;
    }

    public void setColSep(String colSep) {
        this.colSep = colSep;
    }

    public void setNewLineSep(String newLineSep) {
        this.newLineSep = newLineSep;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setMinToPrintWithoutSwitching(double minToPrintWithoutSwitching) {
        this.minToPrintWithoutSwitching = minToPrintWithoutSwitching;
    }

    public void setMaxToPrintWithoutSwitching(double maxToPrintWithoutSwitching) {
        this.maxToPrintWithoutSwitching = maxToPrintWithoutSwitching;
    }

    public void setScientificFormat(String scientificFormat) {
        this.scientificFormat = scientificFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setDontOverrideFormat(boolean dontOverrideFormat) {
        this.dontOverrideFormat = dontOverrideFormat;
    }

    public static void setMaxPrintElements(long maxPrintElements) {
        NDArrayStrings.maxPrintElements = maxPrintElements;
    }

    public static long getMaxPrintElements() {
        return maxPrintElements;
    }
}

