/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.serde.jackson.shaded;

import java.io.IOException;
import java.util.Iterator;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.node.ArrayNode;

public class NDArrayTextDeSerializer
extends JsonDeserializer<INDArray> {
    public INDArray deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode n = (JsonNode)jp.getCodec().readTree(jp);
        return this.deserialize(n);
    }

    public INDArray deserialize(JsonNode n) {
        INDArray arr;
        if (!n.has("dataType")) {
            int size = n.size();
            double[] d = new double[size];
            for (int i = 0; i < size; ++i) {
                d[i] = n.get(i).asDouble();
            }
            return Nd4j.create(d);
        }
        String dtype = n.get("dataType").asText();
        DataType dt = DataType.valueOf(dtype);
        ArrayNode shapeNode = (ArrayNode)n.get("shape");
        long[] shape = new long[shapeNode.size()];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = shapeNode.get(i).asLong();
        }
        ArrayNode dataNode = (ArrayNode)n.get("data");
        Iterator iter = dataNode.elements();
        int i = 0;
        switch (dt) {
            case DOUBLE: {
                double[] d = new double[dataNode.size()];
                while (iter.hasNext()) {
                    d[i++] = ((JsonNode)iter.next()).asDouble();
                }
                arr = Nd4j.create(d, shape, 'c');
                break;
            }
            case FLOAT: 
            case HALF: {
                float[] f = new float[dataNode.size()];
                while (iter.hasNext()) {
                    f[i++] = ((JsonNode)iter.next()).floatValue();
                }
                arr = Nd4j.create(f, shape, 'c').castTo(dt);
                break;
            }
            case LONG: {
                long[] l = new long[dataNode.size()];
                while (iter.hasNext()) {
                    l[i++] = ((JsonNode)iter.next()).longValue();
                }
                arr = Nd4j.createFromArray(l).reshape('c', shape);
                break;
            }
            case INT: 
            case SHORT: 
            case UBYTE: {
                int[] a = new int[dataNode.size()];
                while (iter.hasNext()) {
                    a[i++] = ((JsonNode)iter.next()).intValue();
                }
                arr = Nd4j.createFromArray(a).reshape('c', shape).castTo(dt);
                break;
            }
            case BYTE: 
            case BOOL: {
                byte[] b = new byte[dataNode.size()];
                while (iter.hasNext()) {
                    b[i++] = (byte)((JsonNode)iter.next()).intValue();
                }
                arr = Nd4j.createFromArray(b).reshape('c', shape).castTo(dt);
                break;
            }
            case UTF8: {
                String[] s = new String[dataNode.size()];
                while (iter.hasNext()) {
                    s[i++] = ((JsonNode)iter.next()).asText();
                }
                arr = Nd4j.create(s).reshape('c', shape);
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype: " + dt);
            }
        }
        return arr;
    }
}

