/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.systeminfo;

import com.jakewharton.byteunits.BinaryByteUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.common.config.ND4JClassLoading;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.systeminfo.GPUInfo;
import org.nd4j.systeminfo.GPUInfoProvider;
import org.nd4j.versioncheck.VersionCheck;
import org.nd4j.versioncheck.VersionInfo;
import oshi.software.os.OperatingSystem;

public class SystemInfo {
    private static final String FORMAT = "%-40s%s";

    private static void appendField(StringBuilder sb, String name, Object value) {
        sb.append(name).append(": ").append(value.toString()).append("\n");
    }

    private static void appendProperty(StringBuilder sb, String name, String property) {
        SystemInfo.appendField(sb, name, System.getProperty(property));
    }

    private static void appendHeader(StringBuilder sb, String name) {
        sb.append("\n\n---------------").append(name).append("---------------\n\n");
    }

    public static String f(String s1, Object o) {
        return String.format(FORMAT, s1, o == null ? "null" : o.toString()) + "\n";
    }

    public static String fBytes(long bytes) {
        Object s = BinaryByteUnit.format((long)bytes, (String)"#.00");
        String format = "%10s";
        s = String.format(format, s);
        if (bytes >= 1024L) {
            s = (String)s + " (" + bytes + ")";
        }
        return s;
    }

    public static String fBytes(String s1, long bytes) {
        String s = SystemInfo.fBytes(bytes);
        return SystemInfo.f(s1, s);
    }

    private static void appendCUDAInfo(StringBuilder sb, boolean isWindows) {
        ProcessBuilder pb;
        sb.append("Nvidia-smi:\n");
        try {
            pb = new ProcessBuilder("nvidia-smi");
            SystemInfo.appendOutput(sb, pb);
        }
        catch (IOException e) {
            sb.append("nvidia-smi run failed.");
            if (isWindows) {
                sb.append("  Trying in C:\\Program Files\\NVIDIA Corporation\\NVSMI\n");
                try {
                    ProcessBuilder pb2 = new ProcessBuilder("C:\\Program Files\\NVIDIA Corporation\\NVSMI\\nvidia-smi.exe");
                    SystemInfo.appendOutput(sb, pb2);
                }
                catch (IOException e1) {
                    sb.append("C:\\Program Files\\NVIDIA Corporation\\NVSMI\\nvidia-smi run failed\n");
                    sb.append(e1.getMessage());
                }
            }
            sb.append("\n");
        }
        sb.append("\nnvcc --version:\n");
        try {
            pb = new ProcessBuilder("nvcc", "--version");
            SystemInfo.appendOutput(sb, pb);
        }
        catch (IOException e) {
            sb.append("nvcc --version run failed.");
        }
    }

    private static void appendOutput(StringBuilder sb, ProcessBuilder pb) throws IOException {
        pb.redirectErrorStream(true);
        pb.redirectOutput();
        Process p = pb.start();
        try (InputStreamReader isr = new InputStreamReader(p.getInputStream());
             BufferedReader reader = new BufferedReader(isr);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("\n");
    }

    public static String getSystemInfo() {
        StringBuilder sb = new StringBuilder();
        SystemInfo.appendHeader(sb, "ND4J Info");
        Pair<String, String> pair = SystemInfo.inferVersion();
        sb.append(SystemInfo.f("Deeplearning4j Version", pair.getFirst() == null ? "<could not determine>" : pair.getFirst()));
        sb.append(SystemInfo.f("Deeplearning4j CUDA", pair.getSecond() == null ? "<not present>" : pair.getSecond()));
        sb.append("\n");
        boolean isCUDA = false;
        try {
            SystemInfo.appendField(sb, "Nd4j Backend", Nd4j.getBackend().getClass().getSimpleName());
            Properties props = Nd4j.getExecutioner().getEnvironmentInformation();
            double memory = (double)((Long)props.get("memory.available")).longValue() / 1024.0 / 1024.0 / 1024.0;
            String fm = String.format("%.1f", memory);
            sb.append("Backend used: [").append(props.get("backend")).append("]; OS: [").append(props.get("os")).append("]\n");
            sb.append("Cores: [").append(props.get("cores")).append("]; Memory: [").append(fm).append("GB];\n");
            sb.append("Blas vendor: [").append(props.get("blas.vendor")).append("]\n");
            if (Nd4j.getExecutioner().getClass().getSimpleName().equals("CudaExecutioner")) {
                isCUDA = true;
                List devicesList = (List)props.get("cuda.devicesInformation");
                for (Map dev : devicesList) {
                    sb.append("Device Name: [").append(dev.get("cuda.deviceName")).append("]; ").append("CC: [").append(dev.get("cuda.deviceMajor")).append(".").append(dev.get("cuda.deviceMinor")).append("]; Total/free memory: [").append(dev.get("cuda.totalMemory")).append("]").append("\n");
                }
            }
            sb.append("\nExecutor Properties:\n");
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                sb.append(prop.getKey().toString()).append("=").append(prop.getValue()).append("\n");
            }
        }
        catch (Exception e) {
            sb.append("Could not get ND4J info\n");
            sb.append("Exception: ").append(e.getMessage()).append("\n");
            sb.append(ExceptionUtils.getStackTrace((Throwable)e)).append("\n\n");
        }
        SystemInfo.appendHeader(sb, "Hardware Info");
        SystemInfo.appendField(sb, "Available processors (cores)", Runtime.getRuntime().availableProcessors());
        oshi.SystemInfo sys = new oshi.SystemInfo();
        OperatingSystem os = sys.getOperatingSystem();
        String procName = sys.getHardware().getProcessor().getName();
        long totalMem = sys.getHardware().getMemory().getTotal();
        sb.append(SystemInfo.f("Operating System", os.getManufacturer() + " " + os.getFamily() + " " + os.getVersion().getVersion()));
        sb.append(SystemInfo.f("CPU", procName));
        sb.append(SystemInfo.f("CPU Cores - Physical", sys.getHardware().getProcessor().getPhysicalProcessorCount()));
        sb.append(SystemInfo.f("CPU Cores - Logical", sys.getHardware().getProcessor().getLogicalProcessorCount()));
        sb.append(SystemInfo.fBytes("Total System Memory", totalMem));
        sb.append("\n");
        boolean hasGPUs = false;
        ServiceLoader loader = ND4JClassLoading.loadService(GPUInfoProvider.class);
        Iterator iter = loader.iterator();
        if (iter.hasNext()) {
            List<GPUInfo> gpus = ((GPUInfoProvider)iter.next()).getGPUs();
            sb.append(SystemInfo.f("Number of GPUs Detected", gpus.size()));
            if (!gpus.isEmpty()) {
                hasGPUs = true;
            }
            sb.append(String.format("  %-30s %-5s %24s %24s %24s", "Name", "CC", "Total Memory", "Used Memory", "Free Memory")).append("\n");
            for (GPUInfo gpuInfo : gpus) {
                sb.append(gpuInfo).append("\n");
            }
        } else {
            sb.append("GPU Provider not found (are you missing nd4j-native?)");
        }
        SystemInfo.appendHeader(sb, "CUDA Info");
        if (!isCUDA) {
            sb.append("NOT USING CUDA Nd4j\n");
            if (hasGPUs) {
                sb.append("GPUs detected, trying to list CUDA info anyways\n");
            }
        }
        if (isCUDA || hasGPUs) {
            SystemInfo.appendCUDAInfo(sb, SystemUtils.IS_OS_WINDOWS);
        }
        SystemInfo.appendHeader(sb, "OS Info");
        SystemInfo.appendProperty(sb, "OS", "os.name");
        SystemInfo.appendProperty(sb, "Version", "os.version");
        SystemInfo.appendProperty(sb, "Arch", "os.arch");
        SystemInfo.appendHeader(sb, "Memory Settings");
        SystemInfo.appendField(sb, "Free memory (bytes)", Runtime.getRuntime().freeMemory());
        long maxMemory = Runtime.getRuntime().maxMemory();
        SystemInfo.appendField(sb, "Maximum memory (bytes)", maxMemory == Long.MAX_VALUE ? "No Limit" : Long.valueOf(maxMemory));
        SystemInfo.appendField(sb, "Total memory available to JVM (bytes)", Runtime.getRuntime().totalMemory());
        sb.append("\n");
        long xmx = Runtime.getRuntime().maxMemory();
        long jvmTotal = Runtime.getRuntime().totalMemory();
        long javacppMaxPhys = Pointer.maxPhysicalBytes();
        long javacppMaxBytes = Pointer.maxBytes();
        long javacppCurrPhys = Pointer.physicalBytes();
        long javacppCurrBytes = Pointer.totalBytes();
        sb.append(SystemInfo.fBytes("JVM Memory: XMX", xmx)).append(SystemInfo.fBytes("JVM Memory: current", jvmTotal)).append(SystemInfo.fBytes("JavaCPP Memory: Max Bytes", javacppMaxBytes)).append(SystemInfo.fBytes("JavaCPP Memory: Max Physical", javacppMaxPhys)).append(SystemInfo.fBytes("JavaCPP Memory: Current Bytes", javacppCurrBytes)).append(SystemInfo.fBytes("JavaCPP Memory: Current Physical", javacppCurrPhys));
        boolean periodicGcEnabled = Nd4j.getMemoryManager().isPeriodicGcActive();
        long autoGcWindow = Nd4j.getMemoryManager().getAutoGcWindow();
        sb.append(SystemInfo.f("Periodic GC Enabled", periodicGcEnabled));
        if (periodicGcEnabled) {
            sb.append(SystemInfo.f("Periodic GC Frequency", autoGcWindow + " ms"));
        }
        SystemInfo.appendHeader(sb, "Workspace Information");
        List<MemoryWorkspace> allWs = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
        sb.append(SystemInfo.f("Workspaces: # for current thread", allWs == null ? 0 : allWs.size()));
        long totalWsSize = 0L;
        if (allWs != null && allWs.size() > 0) {
            sb.append("Current thread workspaces:\n");
            String wsFormat = "  %-26s%-12s%-30s%-20s";
            sb.append(String.format(wsFormat, "Name", "State", "Size", "# Cycles")).append("\n");
            for (MemoryWorkspace memoryWorkspace : allWs) {
                totalWsSize += memoryWorkspace.getCurrentSize();
                long numCycles = memoryWorkspace.getGenerationId();
                sb.append(String.format(wsFormat, memoryWorkspace.getId(), memoryWorkspace.isScopeActive() ? "OPEN" : "CLOSED", SystemInfo.fBytes(memoryWorkspace.getCurrentSize()), String.valueOf(numCycles))).append("\n");
            }
        }
        sb.append(SystemInfo.fBytes("Workspaces total size", totalWsSize));
        SystemInfo.appendHeader(sb, "JVM Info");
        SystemInfo.appendProperty(sb, "Runtime Name", "java.runtime.name");
        SystemInfo.appendProperty(sb, "Java Version", "java.version");
        SystemInfo.appendProperty(sb, "Runtime Version", "java.runtime.version");
        SystemInfo.appendProperty(sb, "Vendor", "java.vm.vendor");
        SystemInfo.appendProperty(sb, "Vendor Url", "java.vendor.url");
        sb.append("\n");
        SystemInfo.appendProperty(sb, "VM Name", "java.vm.name");
        SystemInfo.appendProperty(sb, "VM Version", "java.vm.version");
        SystemInfo.appendProperty(sb, "VM Specification Name", "java.vm.specification.name");
        sb.append("\n");
        SystemInfo.appendProperty(sb, "Library Path", "java.library.path");
        SystemInfo.appendHeader(sb, "Classpath");
        URLClassLoader urlClassLoader = null;
        if (ND4JClassLoading.getNd4jClassloader() instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)ND4JClassLoading.getNd4jClassloader();
        } else if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        } else if (SystemInfo.class.getClassLoader() instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)SystemInfo.class.getClassLoader();
        } else if (Thread.currentThread().getContextClassLoader() instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        } else {
            sb.append("Can't cast class loader to URLClassLoader\n");
        }
        if (urlClassLoader != null) {
            for (URL url : urlClassLoader.getURLs()) {
                sb.append(url.getFile()).append("\n");
            }
        } else {
            String[] cps;
            sb.append("Using System property java.class.path\n");
            for (String c : cps = System.getProperty("java.class.path").split(";")) {
                sb.append(c).append("\n");
            }
        }
        SystemInfo.appendHeader(sb, "Launch Command");
        try {
            SystemInfo.appendProperty(sb, "Launch Command", "sun.java.command");
        }
        catch (Exception e) {
            SystemInfo.appendField(sb, "Launch Command", "Not available on this JVM");
        }
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        SystemInfo.appendField(sb, "JVM Arguments", inputArguments);
        SystemInfo.appendHeader(sb, "System Properties");
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (prop.getKey().toString().equals("line.separator")) {
                sb.append(prop.getKey().toString()).append("=").append(prop.getValue().toString().replace("\\", "\\\\")).append("\n");
                continue;
            }
            sb.append(prop.getKey().toString()).append("=").append(prop.getValue()).append("\n");
        }
        SystemInfo.appendHeader(sb, "Environment Variables");
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            sb.append(key).append("=").append(env.get(key)).append("\n");
        }
        return sb.toString();
    }

    public static void writeSystemInfo(File file) {
        try {
            file.createNewFile();
            FileUtils.writeStringToFile((File)file, (String)SystemInfo.getSystemInfo());
        }
        catch (IOException e) {
            throw new RuntimeException("IOException:" + e.getMessage(), e);
        }
    }

    public static void printSystemInfo() {
        System.out.println(SystemInfo.getSystemInfo());
    }

    public static Pair<String, String> inferVersion() {
        List<VersionInfo> vi = VersionCheck.getVersionInfos();
        Object dl4jVersion = null;
        String dl4jCudaArtifact = null;
        for (VersionInfo v : vi) {
            if ("org.deeplearning4j".equals(v.getGroupId()) && "deeplearning4j-core".equals(v.getArtifactId())) {
                String version = v.getBuildVersion();
                if (version.contains("SNAPSHOT")) {
                    dl4jVersion = version + " (" + v.getCommitIdAbbrev() + ")";
                }
                dl4jVersion = version;
                continue;
            }
            if (!"org.deeplearning4j".equals(v.getGroupId()) || v.getArtifactId() == null) continue;
            dl4jCudaArtifact = v.getArtifactId();
        }
        return new Pair(dl4jVersion, dl4jCudaArtifact);
    }
}

