/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners.records;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.IMetric;
import org.nd4j.shade.guava.base.Predicate;
import org.nd4j.shade.guava.base.Predicates;
import org.nd4j.shade.guava.collect.Collections2;

public class EvaluationRecord {
    private Map<String, List<IEvaluation>> evaluations;
    private Map<Class<? extends IEvaluation>, IEvaluation> classEvaluations = new HashMap<Class<? extends IEvaluation>, IEvaluation>();
    private boolean isEmpty = true;

    public EvaluationRecord(Map<String, List<IEvaluation>> evaluations) {
        this.evaluations = Collections.unmodifiableMap(evaluations);
        for (List<IEvaluation> le : evaluations.values()) {
            for (IEvaluation e : le) {
                this.isEmpty = false;
                if (this.classEvaluations.containsKey(e.getClass())) {
                    this.classEvaluations.remove(e.getClass());
                    continue;
                }
                this.classEvaluations.put(e.getClass(), e);
            }
        }
    }

    private EvaluationRecord() {
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public Map<String, List<IEvaluation>> evaluations() {
        return this.evaluations;
    }

    public List<IEvaluation> evaluations(String param) {
        Preconditions.checkArgument((boolean)this.evaluations.containsKey(param), (String)"No evaluations for %s.", (Object)param);
        return this.evaluations.get(param);
    }

    public List<IEvaluation> evaluations(SDVariable param) {
        return this.evaluations(param.name());
    }

    public IEvaluation evaluation(String param, int index) {
        return this.evaluations(param).get(index);
    }

    public IEvaluation evaluation(SDVariable param, int index) {
        return this.evaluation(param.name(), index);
    }

    public <T extends IEvaluation> T evaluation(String param) {
        Preconditions.checkArgument((boolean)this.evaluations.containsKey(param), (String)"No evaluations for %s.", (Object)param);
        Preconditions.checkArgument((this.evaluations.get(param).size() == 1 ? 1 : 0) != 0, (String)"Multiple evaluations for %s.  Use evaluations().", (Object)param);
        return (T)this.evaluations.get(param).get(0);
    }

    public <T extends IEvaluation> T evaluation(SDVariable param) {
        return this.evaluation(param.name());
    }

    public <T extends IEvaluation<T>> T evaluation(Class<T> evalClass) {
        Preconditions.checkArgument((boolean)this.classEvaluations.containsKey(evalClass), (String)"Can't get evaluation for %s.  Either no evaluations with that class are present, or more than one are.", evalClass);
        return (T)this.classEvaluations.get(evalClass);
    }

    public <T extends IEvaluation<T>> T evaluation(String param, Class<T> evalClass) {
        Collection evals = Collections2.filter(this.evaluations(param), (Predicate)Predicates.instanceOf(evalClass));
        Preconditions.checkArgument((evals.size() == 1 ? 1 : 0) != 0, (String)"Multiple or no evaluations of type %s for param %s.", evalClass, (Object)param);
        return (T)((IEvaluation)evals.iterator().next());
    }

    public <T extends IEvaluation<T>> T evaluation(SDVariable param, Class<T> evalClass) {
        return this.evaluation(param.name(), evalClass);
    }

    public double getValue(IMetric metric) {
        return this.evaluation(metric.getEvaluationClass()).getValue(metric);
    }

    public double getValue(String param, IMetric metric) {
        return this.evaluation(param, metric.getEvaluationClass()).getValue(metric);
    }

    public double getValue(SDVariable param, IMetric metric) {
        return this.getValue(param.name(), metric);
    }

    public double getValue(String param, int index, IMetric metric) {
        return this.evaluation(param, index).getValue(metric);
    }

    public double getValue(SDVariable param, int index, IMetric metric) {
        return this.getValue(param.name(), index, metric);
    }

    public Map<String, List<IEvaluation>> getEvaluations() {
        return this.evaluations;
    }

    public Map<Class<? extends IEvaluation>, IEvaluation> getClassEvaluations() {
        return this.classEvaluations;
    }
}

